<?php
session_start();
include ("./connect.php");

// Get logo from database
$logoQuery = "SELECT logo FROM settings LIMIT 1";
$logoResult = $conn->query($logoQuery);
$logo = "images/logo/logo4.png"; // default logo
if ($logoResult && $logoResult->num_rows > 0) {
    $logoData = $logoResult->fetch_assoc();
    $logo = $logoData['logo'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $mobile_number = $_POST['mobile_number'];
    $password = $_POST['password'];

    // Validate inputs
    if(empty($username) || empty($mobile_number) || empty($password)) {
        $_SESSION['message'] = ['type' => 'error', 'text' => 'সমস্ত ফিল্ড পূরণ করা আবশ্যক'];
        header("Location: register.php");
        exit();
    }

    // Check if mobile number already exists
    $checkQuery = "SELECT * FROM user WHERE mobile_number = ?";
    $stmt = $conn->prepare($checkQuery);
    $stmt->bind_param("s", $mobile_number);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $_SESSION['message'] = ['type' => 'error', 'text' => 'এই মোবাইল নম্বর ইতিমধ্যে রেজিস্টার্ড'];
        header("Location: register.php");
        exit();
    } else {
        $insertQuery = "INSERT INTO user (username, mobile_number, password) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($insertQuery);
        $stmt->bind_param("sss", $username, $mobile_number, $password);

        if ($stmt->execute()) {
            $_SESSION['message'] = ['type' => 'success', 'text' => 'রেজিস্ট্রেশন সফল হয়েছে'];
            $_SESSION['username'] = $username;
            $_SESSION['mobile_number'] = $mobile_number;
            $_SESSION['password'] = $password;
            $_SESSION['Balancer'] = 100;
            $_SESSION['user_id'] = $stmt->insert_id;
            $_SESSION['logged_in'] = TRUE;
            header("Location: dashboard.php");
            exit();
        } else {
            $_SESSION['message'] = ['type' => 'error', 'text' => 'ত্রুটি: ' . $stmt->error];
        }
    }

    $stmt->close();
    $conn->close();
    exit();
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="nUe3p1mQveCc0oNl6UWdbUKg8A4IWynRi1XCuPOP">
    <title>ব্যাংক লোন - রেজিস্ট্রেশন</title>
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="images/logo/favicon.ico" type="image/x-icon">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts - Bengali -->
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Animate CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    
    <style>
        :root {
            --primary-color: #6c5ce7;
            --secondary-color: #5649c0;
            --accent-color: #00cec9;
            --light-color: #f8f9fa;
            --dark-color: #2d3436;
            --success-color: #00b894;
            --danger-color: #d63031;
            --gradient-start: #6c5ce7;
            --gradient-end: #a29bfe;
        }
        
        body {
            font-family: 'Hind Siliguri', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #dfe6e9 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .auth-container {
            max-width: 480px;
            margin: 2rem auto;
            padding: 2.5rem;
            background: rgba(255, 255, 255, 0.98);
            border-radius: 16px;
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.3);
            animation: fadeInUp 0.6s ease-out;
            position: relative;
            overflow: hidden;
        }
        
        .auth-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 6px;
            background: linear-gradient(to right, var(--gradient-start), var(--gradient-end));
        }
        
        .auth-header {
            text-align: center;
            margin-bottom: 2.5rem;
        }
        
        .logo {
            width: 90px;
            height: 90px;
            object-fit: contain;
            margin-bottom: 1.2rem;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.1));
        }
        
        .auth-title {
            color: var(--dark-color);
            font-weight: 700;
            margin-bottom: 0.5rem;
            font-size: 1.8rem;
        }
        
        .auth-subtitle {
            color: #636e72;
            font-size: 1rem;
            opacity: 0.9;
        }
        
        .form-label {
            font-weight: 600;
            color: var(--dark-color);
            margin-bottom: 0.5rem;
            font-size: 0.95rem;
        }
        
        .form-control {
            padding: 14px 16px;
            border-radius: 10px;
            border: 1px solid #dfe6e9;
            transition: all 0.3s;
            font-family: 'Hind Siliguri', sans-serif;
            font-size: 0.95rem;
            box-shadow: none;
        }
        
        .form-control:focus {
            border-color: var(--accent-color);
            box-shadow: 0 0 0 0.2rem rgba(108, 92, 231, 0.15);
        }
        
        .input-group-text {
            background-color: #f1f2f6;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
            padding: 0 15px;
        }
        
        .input-group-text:hover {
            background-color: #dfe4ea;
        }
        
        .btn-primary {
            background: linear-gradient(to right, var(--gradient-start), var(--gradient-end));
            border: none;
            padding: 14px;
            font-weight: 600;
            border-radius: 10px;
            letter-spacing: 0.5px;
            transition: all 0.3s;
            width: 100%;
            font-family: 'Hind Siliguri', sans-serif;
            font-size: 1rem;
            margin-top: 0.5rem;
            box-shadow: 0 4px 12px rgba(108, 92, 231, 0.25);
        }
        
        .btn-primary:hover {
            background: linear-gradient(to right, var(--secondary-color), var(--gradient-start));
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(108, 92, 231, 0.35);
        }
        
        .auth-footer {
            text-align: center;
            margin-top: 1.8rem;
            color: #636e72;
            font-size: 0.95rem;
        }
        
        .auth-link {
            color: var(--primary-color);
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s;
        }
        
        .auth-link:hover {
            color: var(--secondary-color);
            text-decoration: underline;
        }
        
        .partners {
            display: flex;
            justify-content: center;
            gap: 15px;
            flex-wrap: wrap;
            margin: 2rem 0;
        }
        
        .partner-logo {
            height: 28px;
            opacity: 0.8;
            transition: all 0.3s;
        }
        
        .partner-logo:hover {
            opacity: 1;
            transform: scale(1.1);
        }
        
        /* Alert styles */
        .alert {
            border-radius: 10px;
            padding: 12px 16px;
            font-size: 0.95rem;
            border: none;
        }
        
        /* Animation for form elements */
        .form-group {
            animation: fadeIn 0.5s ease-out;
            animation-fill-mode: both;
            margin-bottom: 1.5rem;
        }
        
        .form-group:nth-child(1) { animation-delay: 0.2s; }
        .form-group:nth-child(2) { animation-delay: 0.3s; }
        .form-group:nth-child(3) { animation-delay: 0.4s; }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Responsive adjustments */
        @media (max-width: 576px) {
            .auth-container {
                padding: 1.8rem;
                margin: 1rem;
                border-radius: 12px;
            }
            
            .logo {
                width: 138px;
                height: 80px;
            }
            
            .auth-title {
                font-size: 1.6rem;
            }
            
            .form-control {
                padding: 12px 14px;
            }
        }
        
        @media (max-width: 400px) {
            .auth-container {
                padding: 1.5rem;
            }
            
            .auth-header {
                margin-bottom: 1.8rem;
            }
        }
                      /* Hidden audio player styles */
        .hidden-audio-player {
            position: absolute;
            width: 1px;
            height: 1px;
            padding: 0;
            margin: -1px;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            white-space: nowrap;
            border: 0;
        }
        
        /* Loading indicator (optional) */
        .audio-loading {
            display: none;
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: rgba(0,0,0,0.7);
            color: white;
            padding: 10px 15px;
            border-radius: 20px;
            font-size: 14px;
            z-index: 1000;
        }
    </style>
</head>
<body>
        <!-- Hidden audio element -->
    <audio id="pageAudio" class="hidden-audio-player">
        <source src="images/Audio/register_page_audio.mp3" type="audio/mpeg">
        Your browser does not support the audio element.
    </audio>
    <div class="container my-auto py-4">
        <div class="auth-container animate__animated animate__fadeIn">
            <div class="auth-header">
                <img src="<?php echo htmlspecialchars($logo); ?>" alt="লোগো" class="logo">
                <h2 class="auth-title">নতুন নিবন্ধন করুন</h2>
                <p class="auth-subtitle">আপনার তথ্য দিয়ে নিবন্ধন করুন</p>
            </div>

            <?php if (isset($_SESSION['message'])): ?>
                <div class="alert alert-<?php echo $_SESSION['message']['type'] === 'error' ? 'danger' : 'success'; ?> animate__animated animate__fadeIn">
                    <?php echo htmlspecialchars($_SESSION['message']['text']); ?>
                </div>
                <?php unset($_SESSION['message']); ?>
            <?php endif; ?>

            <form id="registrationForm" method="post" action="register.php">
                <div class="form-group">
                    <label for="username" class="form-label">ব্যবহারকারীর নাম</label>
                    <input type="text" name="username" class="form-control" placeholder="আপনার ইউজারনেম লিখুন" required>
                </div>
                
                <div class="form-group">
                    <label for="mobile_number" class="form-label">মোবাইল নম্বর</label>
                    <div class="input-group">
                        <input type="tel" id="mobile_number" name="mobile_number" class="form-control" placeholder="01XXXXXXXXX" required>
                        <span class="input-group-text" onclick="pasteClipboard()">
                            <i class="fas fa-paste"></i>
                        </span>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="password" class="form-label">পাসওয়ার্ড</label>
                    <div class="input-group">
                        <input type="password" name="password" id="password" class="form-control" placeholder="শক্তিশালী পাসওয়ার্ড দিন" required>
                        <span class="input-group-text" onclick="togglePassword('password')">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary mb-4">
                    <i class="fas fa-user-plus me-2"></i> রেজিস্টার করুন
                </button>
                
                <div class="partners">
                    <img src="images/sponsor/1.png" alt="পার্টনার ১" class="partner-logo">
                    <img src="images/sponsor/2.png" alt="পার্টনার ২" class="partner-logo">
                    <img src="images/sponsor/3.png" alt="পার্টনার ৩" class="partner-logo">
                </div>
                
                <div class="auth-footer">
                    <p>ইতিমধ্যে একটি অ্যাকাউন্ট আছে? <a href="login.php" class="auth-link">লগইন করুন</a></p>
                </div>
            </form>
        </div>
    </div>
  <!-- Footer Navigation Start -->
  
        <?php

        include ("footer_index.php")
        ?>
    <!-- Footer Navigation Start -->
    <!-- jQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Clipboard paste function
        function pasteClipboard() {
            navigator.clipboard.readText().then(function(text) {
                document.getElementById("mobile_number").value = text;
                showToast('মোবাইল নম্বর পেস্ট করা হয়েছে', 'success');
            }).catch(function(err) {
                showToast('ক্লিপবোর্ড এক্সেস করতে পারছি না', 'error');
            });
        }
        
        // Toggle password visibility
        function togglePassword(id) {
            const input = document.getElementById(id);
            const icon = input.nextElementSibling.querySelector('i');
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }
        
        // Simple toast notification
        function showToast(message, type) {
            const toast = document.createElement('div');
            toast.className = `toast-${type}`;
            toast.style.position = 'fixed';
            toast.style.bottom = '20px';
            toast.style.right = '20px';
            toast.style.padding = '14px 20px';
            toast.style.background = type === 'success' ? 'var(--success-color)' : 'var(--danger-color)';
            toast.style.color = 'white';
            toast.style.borderRadius = '10px';
            toast.style.boxShadow = '0 6px 16px rgba(0,0,0,0.15)';
            toast.style.zIndex = '9999';
            toast.style.animation = 'fadeIn 0.3s, fadeOut 0.3s 2.7s';
            toast.style.fontFamily = 'var(--bs-font-sans-serif)';
            toast.style.fontSize = '0.95rem';
            toast.textContent = message;
            
            document.body.appendChild(toast);
            setTimeout(() => {
                toast.remove();
            }, 3000);
        }
        
        // Form validation
        document.getElementById('registrationForm').addEventListener('submit', function(e) {
            const mobileNumber = document.getElementById('mobile_number').value;
            if (!/^01[3-9]\d{8}$/.test(mobileNumber)) {
                e.preventDefault();
                showToast('সঠিক মোবাইল নম্বর দিন (01XXXXXXXXX)', 'error');
            }
        });
                document.addEventListener('DOMContentLoaded', function() {
            const audio = document.getElementById('pageAudio');
            const loadingIndicator = document.getElementById('audioLoading');
            
            // Check if audio should play (can add conditions here)
            const shouldPlayAudio = true; // Change this based on your needs
            
            if (shouldPlayAudio) {
                // Show loading indicator (optional)
                if (loadingIndicator) loadingIndicator.style.display = 'block';
                
                // Play audio
                audio.play().then(() => {
                    // Audio started playing
                    console.log('Audio playback started');
                }).catch(error => {
                    console.error('Audio playback failed:', error);
                    if (loadingIndicator) loadingIndicator.style.display = 'none';
                });
                
                // Hide loading indicator when audio ends
                audio.addEventListener('ended', function() {
                    if (loadingIndicator) loadingIndicator.style.display = 'none';
                    console.log('Audio playback completed');
                });
                
                // Handle errors
                audio.addEventListener('error', function() {
                    if (loadingIndicator) loadingIndicator.style.display = 'none';
                    console.error('Error occurred during audio playback');
                });
            }
        });

        // Fallback for browsers that don't support autoplay
        function playAudioOnInteraction() {
            const audio = document.getElementById('pageAudio');
            const loadingIndicator = document.getElementById('audioLoading');
            
            if (loadingIndicator) loadingIndicator.style.display = 'block';
            
            audio.play().then(() => {
                console.log('Audio playback started after interaction');
            }).catch(error => {
                console.error('Audio playback failed:', error);
                if (loadingIndicator) loadingIndicator.style.display = 'none';
            });
        }

        // Add click event listener to document as fallback
        document.addEventListener('click', function() {
            const audio = document.getElementById('pageAudio');
            if (audio.paused) {
                playAudioOnInteraction();
            }
        }, { once: true });
    </script>
</body>
</html>