<div class="col-12 text-center">
    <?php
    // Fetch all loan names
    $sql_loan_name = "SELECT * FROM `loanname` ORDER BY `id` ASC";
    $result_loan_name = mysqli_query($conn, $sql_loan_name);
    $loan_names = mysqli_fetch_all($result_loan_name, MYSQLI_ASSOC);

    // Fetch all product loans
    $sql_product_loan = "SELECT * FROM `productloan` ORDER BY `loanTime` ASC";
    $result_product_loan = mysqli_query($conn, $sql_product_loan);
    $product_loans = mysqli_fetch_all($result_product_loan, MYSQLI_ASSOC);

    // Get first loan for default display
    $first_loan = $product_loans[0] ?? [];
    ?>

    <h6>ঋণের পরিমাণ <span>৳ <label id="loandetail_amount"><?php echo $first_loan['loanAmount'] ?? ''; ?></label></span></h6>

    <form method="POST" action="" class="mt-1" onsubmit="updateLoanPrice()">
        <input type="hidden" name="csrf_token" value="">
        <input type="hidden" name="loan_id" id="loan_id" value="<?php echo $first_loan['loanId'] ?? ''; ?>">
        <input type="hidden" name="loan_price" id="loan_price" value="">

        <div class="d-flex justify-content-center mb-2">
            <span class="total_loan_detail_pcs">
                <?php
                foreach ($loan_names as $index => $loan) {
                    $active_class = ($index == 0) ? 'active-label' : '';
                    echo '<span class="range-label ' . $active_class . '" data-loan-id="' . $loan['id'] . '" onclick="monthSession(' . $loan['id'] . ')">
                        <i class="fas fa-coins"></i> লোনঃ' . htmlspecialchars($loan['loanName']) . '</span>';
                }
                ?>
            </span>
        </div>

        <input type="range" min="0" max="5" value="0" id="range" step="2" class="form-range" onchange="updateAmount()">
        <p class="d-none">ঋণের পরিমাণ: <span id="selected_amount">5000</span></p>

        <h6>ঋণের মেয়াদ (মাস)</h6>

        <div id="selectmonth" class="d-flex justify-content-center gap-2 mb-2">
            <span class="amountBtn btn btn-outline-success" onclick="selectDuration(3)">৩ মাস</span>
            <span class="amountBtn btn btn-outline-success" onclick="selectDuration(6)">৬ মাস</span>
            <span class="amountBtn btn btn-outline-success" onclick="selectDuration(9)">৯ মাস</span>
            <span class="amountBtn btn btn-outline-success" onclick="selectDuration(12)">১২ মাস</span>
        </div>

        <div id="loanDetails" class="alert card text-center text-dark" style="display: none; border: 1px solid #000;">
            <p style="border: 1px solid #ddd;">জামানতঃ <span id="advance_amount">0</span> টাকা</p>
            <p style="border: 1px solid #ddd;">সুদের হারঃ <span id="interest_rate">0</span> %</p>
            <p style="border: 1px solid #ddd;">মোট কিস্তি সংখ্যঃ <span id="total_installments">0</span></p>
            <p style="border: 1px solid #ddd;">কিস্তির পরিমানঃ <span id="installment_amount">0</span> টাকা</p>
            <p style="border: 1px solid #ddd;">মোট পরিশোধকৃতঃ <span id="total_payable">0</span> টাকা</p>
        </div>

        <input type="submit" value="Apply" class="btn submitBtn my-3 w-100">
    </form>


</div>