<!-- Footer Navigation Start -->
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fixed Footer Navigation</title>
  <style>
    html, body {
      margin: 0;
      padding: 0;
      overflow-x: hidden;
    }

    .footer {
      position: fixed;
      bottom: 0;
      width: 100%;
      background: rgba(15, 32, 39, 0.95);
      backdrop-filter: blur(4px);
      color: white;
      padding: 10px 0;
      box-shadow: 0 -4px 20px rgba(0, 0, 0, 0.4);
      z-index: 999;
      transition: background 0.3s ease;
    }

    .footer.scrolled {
      background: rgba(15, 32, 39, 0.8);
    }

    .footer .row {
      display: flex;
      justify-content: space-around;
      align-items: center;
      text-align: center;
      max-width: 1000px;
      margin: 0 auto;
      padding: 0 10px;
      flex-wrap: wrap;
      box-sizing: border-box;
      overflow-x: hidden;
    }

    .footer .col {
      flex: 1 1 22%;
      min-width: 60px;
      max-width: 25%;
      margin: 5px 0;
      box-sizing: border-box;
    }

    .footer .col a {
      display: flex;
      flex-direction: column;
      align-items: center;
      text-decoration: none;
      color: white;
      transition: transform 0.3s;
    }

    .footer .col a:hover {
      transform: scale(1.1);
    }

    .footer-icon {
      width: 100%;
      max-width: 48px;
      height: auto;
      object-fit: contain;
      transition: all 0.3s ease-in-out;
      filter: drop-shadow(0 4px 8px rgba(0,0,0,0.4));
    }

    .footer p {
      margin: 4px 0 0;
      font-size: 14px;
    }

    .footer .col:nth-child(1) img {
      animation: float1 4s ease-in-out infinite;
      filter: drop-shadow(0 5px 12px rgba(255, 111, 0, 0.4));
    }

    .footer .col:nth-child(2) img {
      animation: float2 5s ease-in-out infinite;
      filter: drop-shadow(0 5px 12px rgba(37, 211, 102, 0.5));
    }

    .footer .col:nth-child(3) img {
      animation: float3 4.5s ease-in-out infinite;
      filter: drop-shadow(0 5px 12px rgba(255, 255, 0, 0.5));
    }

    .footer .col:nth-child(4) img {
      animation: float4 5.2s ease-in-out infinite;
      filter: drop-shadow(0 5px 12px rgba(0, 123, 255, 0.5));
    }

    @keyframes float1 {
      0%, 100% { transform: translateY(0px) rotateZ(0deg); }
      50% { transform: translateY(-4px) rotateZ(1deg); }
    }

    @keyframes float2 {
      0%, 100% { transform: translateY(0px) rotateZ(0deg); }
      50% { transform: translateY(-3px) rotateZ(-1deg); }
    }

    @keyframes float3 {
      0%, 100% { transform: translateY(0px) rotateZ(0deg); }
      50% { transform: translateY(-5px) rotateZ(1deg); }
    }

    @keyframes float4 {
      0%, 100% { transform: translateY(0px) rotateZ(0deg); }
      50% { transform: translateY(-3px) rotateZ(-1.5deg); }
    }

    @media (max-width: 768px) {
      .footer-icon {
        max-width: 38px;
      }
      .footer p {
        font-size: 12px;
      }
    }

    @media (max-width: 480px) {
      .footer .row {
        flex-direction: row;
        justify-content: space-between;
        padding: 0 10px;
      }
      .footer-icon {
        max-width: 32px;
      }
      .footer p {
        font-size: 11px;
      }
      .footer .col {
        flex: 1 1 22%;
      }
    }
  </style>
</head>
<body>

<div class="footer" id="footer">
  <div class="row">
    <!-- Home -->
    <div class="col">
      <a href="/">
        <img class="footer-icon" src="/images/footer/home.png" alt="Home">
        <p>Home</p>
      </a>
    </div>

    <!-- WhatsApp -->
    <div class="col">
      <a href="https://wa.me/<?php echo '+'.$whatsapp_number; ?>" target="_blank">
        <img class="footer-icon" src="/images/footer/whatsapp.png" alt="WhatsApp">
        <p>WhatsApp</p>
      </a>
    </div>

    <!-- Sign-Up -->
    <div class="col">
      <a href="register.php">
        <img class="footer-icon" src="/images/footer/signup.png" alt="Sign-Up">
        <p>Sign-Up</p>
      </a>
    </div>

    <!-- Login -->
    <div class="col">
      <a href="login.php">
        <img class="footer-icon" src="/images/footer/login.png" alt="Login">
        <p>Login</p>
    
                </div>
            </div>
        </div>
    </div>
 <br><br> <br>
    <!-- Scripts -->