<?php
// Start session only once
header('Content-Type: text/html; charset=UTF-8');
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection
$host = "localhost";
$user = "loannowl_loan1";
$pass = "loannowl_loan1";
$dbname = "loannowl_loan1";

$conn = new mysqli($host, $user, $pass, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$conn->set_charset("utf8mb4");

// Create all necessary tables if they don't exist
$createTables = [
    "CREATE TABLE IF NOT EXISTS `user` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `username` varchar(50) NOT NULL,
        `mobile_number` varchar(20) NOT NULL,
        `password` varchar(255) NOT NULL,
        `Balancer` decimal(10,2) DEFAULT 0.00,
        `profile_picture` varchar(255) DEFAULT 'images/profile/userimg.jpeg',
        `logged_in` tinyint(1) DEFAULT 0,
        `created_at` datetime DEFAULT current_timestamp(),
        PRIMARY KEY (`id`),
        UNIQUE KEY `username` (`username`),
        UNIQUE KEY `mobile_number` (`mobile_number`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

    "CREATE TABLE IF NOT EXISTS `settings` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `logo` varchar(255) DEFAULT 'images/logo/logo4.png',
        `site_name` varchar(100) DEFAULT NULL,
        `contact_email` varchar(100) DEFAULT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
    
    "CREATE TABLE IF NOT EXISTS `testimonials` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(100) NOT NULL,
        `message` text NOT NULL,
        `date` datetime DEFAULT current_timestamp(),
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

    "CREATE TABLE IF NOT EXISTS `contact` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `whatsapp` varchar(20) NOT NULL,
        `youtube` varchar(255) DEFAULT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

    "CREATE TABLE IF NOT EXISTS `loanname` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `loanName` varchar(100) NOT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

    "CREATE TABLE IF NOT EXISTS `productloan` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `loanId` int(11) NOT NULL,
        `loanAmount` decimal(10,2) NOT NULL,
        `loanTime` int(11) NOT NULL,
        `advance` decimal(10,2) NOT NULL,
        `profitPersatice` decimal(5,2) NOT NULL,
        `totalEmi` int(11) NOT NULL,
        `totalEmiAmount` decimal(10,2) NOT NULL,
        `TotalPayableAmount` decimal(10,2) NOT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",

    "CREATE TABLE IF NOT EXISTS `loan_applications` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `user_id` int(11) NOT NULL,
        `loan_id` int(11) NOT NULL,
        `amount` decimal(10,2) NOT NULL,
        `duration` int(11) NOT NULL,
        `advance` decimal(10,2) NOT NULL,
        `status` enum('pending','approved','rejected') DEFAULT 'pending',
        `created_at` datetime DEFAULT current_timestamp(),
        `next_apply_date` datetime DEFAULT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"
];

foreach ($createTables as $sql) {
    if (!$conn->query($sql)) {
        die("Error creating table: " . $conn->error);
    }
}

// Insert default data if tables are empty
$checkSettings = $conn->query("SELECT COUNT(*) as count FROM `settings`");
if ($checkSettings && $checkSettings->fetch_assoc()['count'] == 0) {
    $conn->query("INSERT INTO `settings` (`logo`, `site_name`, `contact_email`) 
                 VALUES ('images/logo/logo4.png', 'Easy Loan', 'contact@example.com')");
}

$checkTestimonials = $conn->query("SELECT COUNT(*) as count FROM `testimonials`");
if ($checkTestimonials && $checkTestimonials->fetch_assoc()['count'] == 0) {
    $testimonialsData = [
        "INSERT INTO `testimonials` (`name`, `message`, `date`) VALUES 
        ('John Doe', 'Great service! Got my loan quickly.', '2023-01-15 10:30:00')",
        
        "INSERT INTO `testimonials` (`name`, `message`, `date`) VALUES 
        ('Jane Smith', 'Very helpful customer support.', '2023-02-20 11:45:00')",
        
        "INSERT INTO `testimonials` (`name`, `message`, `date`) VALUES 
        ('Robert Johnson', 'Simple process and fast approval.', '2023-03-10 09:15:00')"
    ];
    
    foreach ($testimonialsData as $sql) {
        $conn->query($sql);
    }
}

$checkContact = $conn->query("SELECT COUNT(*) as count FROM `contact`");
if ($checkContact && $checkContact->fetch_assoc()['count'] == 0) {
    $conn->query("INSERT INTO `contact` (`whatsapp`, `youtube`) 
                 VALUES ('8801766301760', 'https://www.youtube.com/watch?v=example')");
}

// Check if user is logged in
if(!isset($_SESSION["logged_in"]) || $_SESSION["logged_in"] !== true) {
    header("location: login.php");
    exit();
}

// Fetch WhatsApp number from database
$sql_whatsapp = "SELECT whatsapp FROM contact LIMIT 1";
$result_whatsapp = mysqli_query($conn, $sql_whatsapp);
$whatsapp_number = "8801766301760"; // Default number

if ($result_whatsapp && mysqli_num_rows($result_whatsapp) > 0) {
    $row = mysqli_fetch_assoc($result_whatsapp);
    $whatsapp_number = preg_replace('/[^0-9]/', '', $row['whatsapp']);
}

$get_videoInfo = "SELECT * FROM `contact` ORDER BY id DESC LIMIT 1";
$sql_video_query = mysqli_query($conn, $get_videoInfo);
$video_info = mysqli_fetch_assoc($sql_video_query);

function getYouTubeID($url) {
    parse_str(parse_url($url, PHP_URL_QUERY), $vars);
    return $vars['v'] ?? '';
}

$get_contacktInfo = "SELECT * FROM `contact` ORDER BY id DESC LIMIT 1";
$sql_query = mysqli_query($conn, $get_contacktInfo);
$contact_info = mysqli_fetch_assoc($sql_query);

// Fetch logo from settings table
$sql_logo = "SELECT logo FROM settings LIMIT 1";
$result_logo = mysqli_query($conn, $sql_logo);
$logo_url = "images/logo/logo4.png";

if ($result_logo && mysqli_num_rows($result_logo) > 0) {
    $row_logo = mysqli_fetch_assoc($result_logo);
    $logo_url = $row_logo['logo'];
}

// Fetch all loan names
$sql_loan_name = "SELECT * FROM `loanname` ORDER BY `id` ASC";
$result_loan_name = mysqli_query($conn, $sql_loan_name);
$loan_names = mysqli_fetch_all($result_loan_name, MYSQLI_ASSOC);

// Fetch all product loans
$sql_product_loan = "SELECT * FROM `productloan` ORDER BY `loanTime` ASC";
$result_product_loan = mysqli_query($conn, $sql_product_loan);
$product_loans = mysqli_fetch_all($result_product_loan, MYSQLI_ASSOC);

// Get first loan for default display
$first_loan = $product_loans[0] ?? [];

// Process form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['loan_id'])) {
    $loan_id = (int) $_POST['loan_id'];
    $duration = isset($_POST['duration']) ? (int)$_POST['duration'] : 0;

    // CSRF protection
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        $_SESSION['message'] = ['type' => 'error', 'text' => 'অবৈধ CSRF টোকেন'];
        header("Location: ".$_SERVER['PHP_SELF']);
        exit();
    }

    // Check if user has any pending or approved loan applications in last 15 days
    $check_previous_application = $conn->prepare("
        SELECT id, status, created_at, next_apply_date 
        FROM loan_applications 
        WHERE user_id = ? 
        AND (status = 'approved' OR (status = 'pending' AND created_at > DATE_SUB(NOW(), INTERVAL 15 DAY)))
        ORDER BY created_at DESC 
        LIMIT 1
    ");
    $check_previous_application->bind_param("i", $_SESSION['user_id']);
    $check_previous_application->execute();
    $previous_application = $check_previous_application->get_result()->fetch_assoc();
    
    if ($previous_application) {
        if ($previous_application['status'] === 'pending') {
            $_SESSION['message'] = [
                'type' => 'error', 
                'text' => 'আপনার একটি লোন আবেদন ইতিমধ্যে প্রক্রিয়াধীন রয়েছে। নতুন আবেদন করতে ১৫ দিন অপেক্ষা করুন।'
            ];
            header("Location: ".$_SERVER['PHP_SELF']);
            exit();
        }
        
        if (isset($previous_application['next_apply_date'])) {
            $next_apply_date = new DateTime($previous_application['next_apply_date']);
            $current_date = new DateTime();
            
            if ($current_date < $next_apply_date) {
                $remaining_days = $current_date->diff($next_apply_date)->days + 1;
                $_SESSION['message'] = [
                    'type' => 'error', 
                    'text' => "আপনি আগামী {$remaining_days} দিন পর নতুন লোনের জন্য আবেদন করতে পারবেন।"
                ];
                header("Location: ".$_SERVER['PHP_SELF']);
                exit();
            }
        }
    }

    // Find the selected loan product
    $selected_loan = null;
    foreach ($product_loans as $loan) {
        if ($loan['loanId'] == $loan_id && $loan['loanTime'] == $duration) {
            $selected_loan = $loan;
            break;
        }
    }

    if ($selected_loan) {
        // Check user balance
        $user_id = $_SESSION['user_id'];
        $current_balance = $_SESSION['Balancer'];
        $advance_amount = $selected_loan['advance'];

        if ($current_balance >= $advance_amount) {
            // Start transaction
            $conn->begin_transaction();
            
            try {
                // Calculate next apply date (15 days from now)
                $next_apply_date = date('Y-m-d H:i:s', strtotime('+15 days'));
                
                // 1. Insert loan application with next_apply_date
                $stmt = $conn->prepare("
                    INSERT INTO loan_applications 
                    (user_id, loan_id, amount, duration, advance, status, next_apply_date) 
                    VALUES (?, ?, ?, ?, ?, 'pending', ?)
                ");
                $stmt->bind_param(
                    "iisiis", 
                    $user_id, 
                    $loan_id, 
                    $selected_loan['loanAmount'], 
                    $duration, 
                    $advance_amount,
                    $next_apply_date
                );
                $stmt->execute();
                
                // 2. Deduct advance from user balance
                $new_balance = $current_balance - $advance_amount;
                $update_stmt = $conn->prepare("UPDATE user SET Balancer = ? WHERE id = ?");
                $update_stmt->bind_param("di", $new_balance, $user_id);
                $update_stmt->execute();
                
                // Commit transaction
                $conn->commit();
                
                // Update session balance
                $_SESSION['Balancer'] = $new_balance;
                
                $_SESSION['message'] = [
                    'type' => 'success', 
                    'text' => 'লোন আবেদন সফলভাবে জমা হয়েছে! অগ্রিম পরিমাণ আপনার ব্যালেন্স থেকে কেটে নেওয়া হয়েছে।',
                    'deducted_amount' => $advance_amount,
                    'new_balance' => $new_balance
                ];
            } catch (Exception $e) {
                // Rollback transaction on error
                $conn->rollback();
                $_SESSION['message'] = ['type' => 'error', 'text' => 'লোন আবেদন প্রক্রিয়াকরণে ত্রুটি: '.$e->getMessage()];
            }
            
            $stmt->close();
            $update_stmt->close();
        } else {
            $_SESSION['message'] = [
                'type' => 'error', 
                'text' => 'এই লোনের জন্য আপনার ব্যালেন্স অপর্যাপ্ত। আপনার প্রয়োজন '.number_format($advance_amount).' BDT অগ্রিম প্রদান।',
                'required_amount' => $advance_amount,
                'current_balance' => $current_balance
            ];
        }
    } else {
        $_SESSION['message'] = ['type' => 'error', 'text' => 'অবৈধ লোন নির্বাচন'];
    }

    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// Fetch testimonials
$sql_testimonials = "SELECT * FROM testimonials ORDER BY id DESC LIMIT 3";
$result_testimonials = mysqli_query($conn, $sql_testimonials);
$testimonials = mysqli_fetch_all($result_testimonials, MYSQLI_ASSOC);

// Generate CSRF token if not exists
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Update user session data
$user_id = $_SESSION['user_id'] ?? null;
if ($user_id) {
    $stmt = $conn->prepare("SELECT id, username, mobile_number, password, Balancer, profile_picture FROM user WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $userData = $result->fetch_assoc();
        $imageUrl = !empty($userData['profile_picture']) ? $userData['profile_picture'] : 'images/profile/userimg.jpeg';

        $_SESSION = array_merge($_SESSION, [
            'id' => $userData['id'],
            'username' => $userData['username'],
            'mobile_number' => $userData['mobile_number'],
            'password' => $userData['password'],
            'Balancer' => $userData['Balancer'],
            'profile_picture' => $imageUrl
        ]);

$messages = [
    "+880181****7294 সফলভাবে উত্তোলন করেছে 20000 BDT",
    "+880171****8361 সফলভাবে উত্তোলন করেছে 50000 BDT",
    "+880191****9452 সফলভাবে উত্তোলন করেছে 5000 BDT",
    "+880161****1583 সফলভাবে উত্তোলন করেছে 30000 BDT",
    "+880152****2674 সফলভাবে উত্তোলন করেছে 10000 BDT",
    "+880162****3795 সফলভাবে উত্তোলন করেছে 40000 BDT",
    "+880172****4826 সফলভাবে উত্তোলন করেছে 5000 BDT",
    "+880182****5937 সফলভাবে উত্তোলন করেছে 20000 BDT",
    "+880192****6048 সফলভাবে উত্তোলন করেছে 50000 BDT",
    "+880153****7159 সফলভাবে উত্তোলন করেছে 30000 BDT",
    "+880163****8260 সফলভাবে উত্তোলন করেছে 10000 BDT",
    "+880173****9371 সফলভাবে উত্তোলন করেছে 40000 BDT",
    "+880183****0482 সফলভাবে উত্তোলন করেছে 5000 BDT",
    "+880193****1593 সফলভাবে উত্তোলন করেছে 50000 BDT",
    "+880154****2604 সফলভাবে উত্তোলন করেছে 20000 BDT",
    "+880164****3715 সফলভাবে উত্তোলন করেছে 30000 BDT",
    "+880174****4826 সফলভাবে উত্তোলন করেছে 10000 BDT",
    "+880184****5937 সফলভাবে উত্তোলন করেছে 40000 BDT",
    "+880194****6048 সফলভাবে উত্তোলন করেছে 5000 BDT",
    "+880155****7159 সফলভাবে উত্তোলন করেছে 50000 BDT",
    "+880165****8260 সফলভাবে উত্তোলন করেছে 20000 BDT",
    "+880175****9371 সফলভাবে উত্তোলন করেছে 30000 BDT",
    "+880185****0482 সফলভাবে উত্তোলন করেছে 10000 BDT",
    "+880195****1593 সফলভাবে উত্তোলন করেছে 40000 BDT",
    "+880156****2604 সফলভাবে উত্তোলন করেছে 5000 BDT",
    "+880166****3715 সফলভাবে উত্তোলন করেছে 50000 BDT",
    "+880176****4826 সফলভাবে উত্তোলন করেছে 20000 BDT",
    "+880186****5937 সফলভাবে উত্তোলন করেছে 30000 BDT",
    "+880196****6048 সফলভাবে উত্তোলন করেছে 10000 BDT",
    "+880157****7159 সফলভাবে উত্তোলন করেছে 40000 BDT",
    "+880167****8260 সফলভাবে উত্তোলন করেছে 5000 BDT",
    "+880177****9371 সফলভাবে উত্তোলন করেছে 50000 BDT",
    "+880187****0482 সফলভাবে উত্তোলন করেছে 20000 BDT",
    "+880197****1593 সফলভাবে উত্তোলন করেছে 30000 BDT",
    "+880158****2604 সফলভাবে উত্তোলন করেছে 10000 BDT",
    "+880168****3715 সফলভাবে উত্তোলন করেছে 40000 BDT",
    "+880178****4826 সফলভাবে উত্তোলন করেছে 5000 BDT",
    "+880188****5937 সফলভাবে উত্তোলন করেছে 50000 BDT",
    "+880198****6048 সফলভাবে উত্তোলন করেছে 20000 BDT",
    "+880159****7159 সফলভাবে উত্তোলন করেছে 30000 BDT",
    "+880169****8260 সফলভাবে উত্তোলন করেছে 10000 BDT",
    "+880179****9371 সফলভাবে উত্তোলন করেছে 40000 BDT",
    "+880189****0482 সফলভাবে উত্তোলন করেছে 5000 BDT",
    "+880199****1593 সফলভাবে উত্তোলন করেছে 50000 BDT",
    "+880150****2604 সফলভাবে উত্তোলন করেছে 20000 BDT",
    "+880160****3715 সফলভাবে উত্তোলন করেছে 30000 BDT",
    "+880170****4826 সফলভাবে উত্তোলন করেছে 10000 BDT",
    "+880180****5937 সফলভাবে উত্তোলন করেছে 40000 BDT",
    "+880190****6048 সফলভাবে উত্তোলন করেছে 5000 BDT",
    "+880151****7159 সফলভাবে উত্তোলন করেছে 50000 BDT"
];

        $notificationItems = '';
        foreach ($messages as $msg) {
            $notificationItems .= '<div class="notification-item">💰 ' . htmlspecialchars($msg) . '</div>';
        }
    }
}

// Check and display next available application date
$next_apply_info = $conn->prepare("
    SELECT next_apply_date 
    FROM loan_applications 
    WHERE user_id = ? 
    AND next_apply_date > NOW()
    ORDER BY next_apply_date DESC 
    LIMIT 1
");
$next_apply_info->bind_param("i", $_SESSION['user_id']);
$next_apply_info->execute();
$next_apply_result = $next_apply_info->get_result();

if ($next_apply_result->num_rows > 0) {
    $next_apply = $next_apply_result->fetch_assoc();
    $next_date = new DateTime($next_apply['next_apply_date']);
    $current_date = new DateTime();
    $interval = $current_date->diff($next_date);
    $remaining_days = $interval->days + 1; // Add 1 to include current day
    
    $_SESSION['next_apply_message'] = [
        'date' => $next_apply['next_apply_date'],
        'days' => $remaining_days
    ];
}

// HTML and frontend display code would continue here...
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0,maximum-scale=1, user-scalable=no">
    <meta name="csrf-token" content="<?php echo $_SESSION['csrf_token']; ?>">
    <title>Easy Loan - <?php echo $_SESSION["logged_in"] ? 'Dashboard' : 'Home'; ?></title>
    <meta name="description" content="মাত্র ১০ মিনিটে ঘরে বসেই অনলাইন লোন নিন — নিরাপদ, দ্রুত ও ঝামেলামুক্ত প্রক্রিয়ায়। ৫,০০০ থেকে ৫০,০০০ টাকা পর্যন্ত লোন, ন্যূনতম ডকুমেন্টে।">
    <link rel="shortcut icon" href="images/logo/favicon.ico" type="image/x-icon">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <!-- Boxicons -->
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    
    <!-- Google Fonts for Bengali -->
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #04460c;
            --secondary-color: #10704b;
            --dark-color: #044315;
            --light-color: #f8f9fa;
            --theme-bg: linear-gradient(135deg, var(--secondary-color), var(--primary-color));
            --theme-text: #ffffff;
            --theme-font-text: #333333;
            --card-shadow: 0 10px 30px rgba(0,0,0,0.08);
        }
        
        body {
            font-family: 'Hind Siliguri', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f3f3ed;
            color: var(--theme-font-text);
            padding-bottom: 70px;
        }
        
        /* Header Styles */
        .app-header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: var(--theme-bg);
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        }
        
        .app-header .logo-container {
            display: flex;
            align-items: center;
        }
        
        .app-header .logo-container img {
            height: 48px;
            object-fit: contain;
        }
        
        .app-header .auth-buttons {
            display: flex;
            gap: 15px;
        }
        
        .app-header .auth-btn {
            padding: 10px 25px;
            font-size: 16px;
            font-weight: 600;
            background: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.3);
            border-radius: 30px;
            transition: all 0.3s ease;
            text-decoration: none;
        }
        
        .app-header .auth-btn:hover {
            background: rgba(255,255,255,0.3);
            transform: translateY(-2px);
        }

        /* User Header for logged in users */
        .sticky-header {
            position: fixed;
            top: 0;
            z-index: 1000;
            background: linear-gradient(90deg, #0f2027, #203a43, #2c5364);
            color: #f0f4f8;
            padding: 10px 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-radius: 0 0 15px 15px;
            box-shadow: 0 6px 15px rgba(0,0,0,0.35);
            font-family: "Hind Siliguri", sans-serif;
            width: 100%;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .user-info img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid #10b981;
            box-shadow: 0 0 10px rgba(16, 185, 129, 0.6);
            transition: transform 0.5s ease;
            animation: glowPulse 3s infinite ease-in-out;
            transform-style: preserve-3d;
        }

        .user-info img:hover {
            transform: rotateY(12deg) rotateX(12deg) scale(1.07);
            box-shadow: 0 0 25px rgba(16, 185, 129, 0.9);
        }

        @keyframes glowPulse {
            0%, 100% { box-shadow: 0 0 12px rgba(16, 185, 129, 0.5); }
            50% { box-shadow: 0 0 22px rgba(16, 185, 129, 0.9); }
        }

        .balance-box {
            background: rgba(255, 255, 255, 0.1);
            padding: 8px 12px;
            border-radius: 8px;
            margin-top: 4px;
            cursor: pointer;
            transition: all 0.4s ease;
            font-weight: 600;
            font-size: 14px;
            color: #e0f2fe;
            border: 1px solid rgba(255, 255, 255, 0.2);
            display: inline-flex;
            align-items: center;
            gap: 8px;
            max-width: 100%;
        }

        .balance-box:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .balance-icon {
            font-size: 16px;
        }

        .balance-value {
            display: none;
            background: linear-gradient(135deg, #10b981, #059669);
            padding: 8px 12px;
            border-radius: 8px;
            font-weight: 700;
            font-size: 16px;
            color: #fff;
            animation: fadeIn 0.5s ease-in-out;
            margin-top: 4px;
            text-align: center;
            max-width: 100%;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        @keyframes fadeIn {
            from {opacity: 0; transform: translateY(-5px); }
            to {opacity: 1; transform: translateY(0); }
        }

        .money-fall-container {
            position: relative;
            width: 50px;
            height: 50px;
            overflow: visible;
        }

        .money-symbol {
            position: absolute;
            top: -20px;
            left: 10px;
            font-size: 24px;
            animation: fallMoney 3s linear infinite;
            color: #facc15;
            text-shadow: 1px 1px 4px #000;
        }

        @keyframes fallMoney {
            0% { transform: translateY(-20px) scale(1); opacity: 0; }
            30% { opacity: 1; }
            70% { opacity: 1; }
            100% { transform: translateY(60px) scale(1.1); opacity: 0; }
        }

        .notification-bell {
            font-size: 30px;
            color: #fff;
            cursor: pointer;
            position: absolute;
            bottom: 10px;
            right: 10px;
            z-index: 1001;
            animation: bellPulse 2s infinite;
        }

        @keyframes bellPulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        .notification-panel {
            position: fixed;
            top: 60px;
            right: -350px;
            width: 340px;
            max-height: 380px;
            background: linear-gradient(145deg, #ffffff, #e6f0f3);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
            border-radius: 20px 0 0 20px;
            overflow: hidden;
            z-index: 2000;
            transition: right 0.5s ease-in-out;
            font-family: "Hind Siliguri", sans-serif;
            padding: 12px 18px;
        }

        .notification-panel.open {
            right: 20px;
        }

        .notification-header {
            font-size: 16px;
            font-weight: 700;
            margin-bottom: 8px;
            color: #1f2937;
            text-align: center;
        }

        .notification-body {
            max-height: 270px;
            overflow: hidden;
            position: relative;
        }

        .notification-scroll {
            display: flex;
            flex-direction: column;
            animation: scrollVertically 25s linear infinite;
        }

        @keyframes scrollVertically {
            0% { transform: translateY(0); }
            100% { transform: translateY(-<?php echo (count($messages) * 50 - 270); ?>px); }
        }

        .notification-item {
            background: linear-gradient(135deg, #c3e0f9, #e0f7fa);
            color: #0f172a;
            font-size: 13px;
            font-weight: 600;
            padding: 12px 16px;
            border-radius: 10px;
            margin-bottom: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
            position: relative;
            overflow: hidden;
        }

        .notification-item:hover {
            transform: scale(1.03);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.25);
        }

        /* Premium Toast Notifications */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1100;
            font-family: 'Hind Siliguri', sans-serif;
        }

        .toast {
            display: block;
            opacity: 1;
            margin-bottom: 15px;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
            border-left: 5px solid;
            overflow: hidden;
            width: 350px;
            transition: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            transform: translateX(400px);
        }

        .toast.show {
            transform: translateX(0);
        }

        .toast-header {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            background: rgba(255,255,255,0.9);
            border-bottom: 1px solid rgba(0,0,0,0.05);
        }

        .toast-body {
            padding: 16px 20px;
            font-size: 14px;
            line-height: 1.5;
        }

        .toast-success {
            border-left-color: #10B981;
        }

        .toast-success .toast-header {
            color: #10B981;
        }

        .toast-error {
            border-left-color: #EF4444;
        }

        .toast-error .toast-header {
            color: #EF4444;
        }

        .toast-icon {
            font-size: 24px;
            margin-right: 12px;
        }

        .toast-close {
            margin-left: auto;
            background: none;
            border: none;
            font-size: 18px;
            cursor: pointer;
            opacity: 0.7;
            transition: opacity 0.2s;
        }

        .toast-close:hover {
            opacity: 1;
        }

        .toast-progress {
            height: 4px;
            background: rgba(0,0,0,0.1);
            width: 100%;
        }

        .toast-progress-bar {
            height: 100%;
            background: currentColor;
            width: 100%;
            animation: progressBar 5s linear forwards;
        }

        @keyframes progressBar {
            0% { width: 100%; }
            100% { width: 0%; }
        }

        /* Main Content Styles */
        .main-container {
            margin-top: 100px;
            margin-bottom: 30px;
            padding: 0 15px;
        }
        
        .announcement-bar {
            background: rgba(255,255,255,0.9);
            border-radius: 10px;
            padding: 1px 15px;
            margin-bottom: 20px;
            box-shadow: var(--card-shadow);
            display: flex;
            align-items: center;
            overflow: hidden;
        }
        
        .announcement-icon {
            font-size: 20px;
            color: var(--primary-color);
            margin-right: 15px;
        }
        
        .announcement-text marquee {
            font-size: 14px;
            font-weight: 500;
        }
        
        /* Popup Modal */
        .popup-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 2000;
            align-items: center;
            justify-content: center;
        }
        
        .popup-content {
            background: white;
            border-radius: 15px;
            width: 90%;
            max-width: 500px;
            padding: 20px;
            text-align: center;
            position: relative;
            animation: popupFadeIn 0.3s ease;
        }
        
        .popup-close {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 24px;
            color: #777;
            cursor: pointer;
        }
        
        .popup-image {
            width: 100%;
            max-height: 400px;
            object-fit: contain;
            border-radius: 10px;
            margin-bottom: 15px;
        }
        
        @keyframes popupFadeIn {
            from { opacity: 0; transform: scale(0.9); }
            to { opacity: 1; transform: scale(1); }
        }
        
        /* Confirmation Modal */
        .confirmation-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 2000;
            align-items: center;
            justify-content: center;
        }
        
        .confirmation-content {
            background: white;
            border-radius: 15px;
            width: 90%;
            max-width: 400px;
            padding: 25px;
            text-align: center;
            position: relative;
            animation: popupFadeIn 0.3s ease;
        }
        
        .confirmation-icon {
            font-size: 60px;
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .confirmation-title {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--secondary-color);
        }
        
        .confirmation-message {
            font-size: 16px;
            margin-bottom: 25px;
            line-height: 1.5;
        }
        
        .confirmation-btn {
            padding: 12px 30px;
            background: var(--primary-color);
            color: white;
            border: none;
            border-radius: 30px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .confirmation-btn:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
        }
        
        /* Loan Services Section */
        .loan-services-section {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 25px;
            margin-bottom: 25px;
            transition: all 0.3s ease;
        }
        
        .loan-services-section:hover {
            box-shadow: 0 15px 40px rgba(0,0,0,0.12);
        }
        
        .section-title {
            color: var(--secondary-color);
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid rgba(76, 200, 90, 0.2);
        }
        
         /* Loan Amount Display */
        .loan-amount-display {
            display: flex;
            background: var(--theme-bg);
            border-radius: 22px;
            padding: 1px;
            text-align: center;
            color: white;
            margin-bottom: 12px;
            position: relative;
            overflow: hidden;
            flex-direction: row;
            justify-content: space-evenly;
            align-content: space-between;
            flex-wrap: nowrap;
            align-items: baseline;
        }
        
        .loan-amount-display::before {
            content: "";
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
            transform: rotate(30deg);
        }
        
        .amount-label {
            font-size: 14px;
            opacity: 0.9;
            margin-bottom: 5px;
        }
        
        .amount-value {
            font-size: 36px;
            font-weight: 700;
            line-height: 1;
            margin: 10px 0;
        }
        
        .amount-currency {
            font-size: 16px;
            opacity: 0.9;
        }
        
        /* Loan Type Selection - 6 in a row */
        .loan-type-selection {
            margin-bottom: 15px;
        }
        
        .loan-type-title {
            display: flex;
            font-size: 14px;
            font-weight: 600;
            justify-content: space-around;
            align-content: space-around;
        }
        
        .loan-type-options {
            display: flex;
            padding-bottom: 10px;
            scrollbar-width: none;
            align-content: space-between;
            flex-direction: row;
            justify-content: space-between;
            align-items: center;
            flex-wrap: nowrap;
        }
        
        .loan-type-option {
            flex: 1;
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px 5px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid #e0e0e0;
            min-width: 120px;
        }
        
        .loan-type-option:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        
        .loan-type-option.active {
            background: var(--theme-bg);
            color: white;
            border-color: var(--primary-color);
        }
        
        .loan-type-option.active .loan-icon {
            color: white;
        }
        
        .loan-icon {
            font-size: 23px;
            color: var(--primary-color);
            margin-bottom: 8px;
        }
        
        .loan-name {
            font-size: 13px;
            font-weight: 500;
        }
        
        /* Amount Slider */
        .amount-slider-section {
            margin-bottom: 10px;
        }
        
        .amount-slider-title {
            display: flex;
            font-size: 14px;
            font-weight: 600;
            align-content: space-between;
            justify-content: space-around;
        }
        
        .loan-amount-slider {
            -webkit-appearance: none;
            width: 100%;
            height: 8px;
            border-radius: 5px;
            background: #e0e0e0;
            outline: none;
            margin: 15px 0;
        }
        
        .loan-amount-slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background: var(--theme-bg);
            cursor: pointer;
            border: 3px solid white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            transition: all 0.2s ease;
        }
        
        .loan-amount-slider::-webkit-slider-thumb:hover {
            transform: scale(1.1);
        }
        
        .slider-labels {
            display: flex;
            justify-content: space-between;
            font-size: 12px;
            color: #7f8c8d;
        }
        
        /* Duration Selection */
        .duration-selection {
            margin-bottom: 25px;
        }
        
        .duration-title {
            display: flex;
            color: var(--secondary-color);
            font-size: 16px;
            margin-bottom: 15px;
            font-weight: 600;
            align-content: space-between;
            justify-content: space-around;
        }
        
        .duration-options {
            display: flex;
            gap: 10px;
        }
        
        .duration-option {
            flex: 1;
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px 5px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid #e0e0e0;
        }
        
        .duration-option:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        
        .duration-option.active {
            background: var(--theme-bg);
            color: white;
            border-color: var(--primary-color);
        }
        
        .duration-months {
            font-size: 20px;
            font-weight: 700;
            line-height: 1;
            margin-bottom: 5px;
        }
        
        .duration-label {
            font-size: 12px;
            opacity: 0.8;
        }
        
        /* Loan Details */
        .loan-details {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 20px;
            margin: 25px 0;
            border: 1px solid #e0e0e0;
            display: none;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .detail-row:last-child {
            border-bottom: none;
        }
        
        .detail-label {
            color: #7f8c8d;
            font-size: 14px;
        }
        
        .detail-value {
            color: var(--secondary-color);
            font-weight: 600;
        }
        
        /* Premium 3D Apply Button */
        .loan-submit-btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #2ecc71, #27ae60);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            position: relative;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(46, 204, 113, 0.4);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .loan-submit-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: 0.5s;
        }
        
        .loan-submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(46, 204, 113, 0.6);
        }
        
        .loan-submit-btn:hover::before {
            left: 100%;
        }
        
        .loan-submit-btn i {
            transition: transform 0.3s ease;
        }
        
        .loan-submit-btn:hover i {
            transform: translateX(5px);
        }
        
        /* Image Slider */
        .image-slider {
            border-radius: 16px;
            overflow: hidden;
            margin-bottom: 25px;
            box-shadow: var(--card-shadow);
        }
        
        .image-slider img {
            width: 100%;
            height: auto;
            display: block;
        }
        
         /* Quick Actions */
        .quick-actions {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .action-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
        }
        
        .action-item {
            text-align: center;
            padding: 15px 5px;
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        
        .action-item:hover {
            background: #f8f9fa;
            transform: translateY(-3px);
        }
        
        .action-item a {
            text-decoration: none;
            color: var(--theme-font-text);
        }
        
        .action-icon {
            font-size: 24px;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        
        .action-label {
            font-size: 13px;
            font-weight: 500;
        }
       
        /* Video Section */
        .video-section {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .video-container {
            position: relative;
            width: 100%;
            border-radius: 12px;
            overflow: hidden;
            background: #f0f0f0;
            margin-top: 15px;
        }
        
        .video-container iframe {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: none;
        }
        
        /* Contact Section */
        .partners-section {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .partners-section p {
            margin-bottom: 15px;
            text-align: center;
        }
        
        /* Partners Section - 4 in a row */
        .partner-grid {
            display: flex;
            flex-wrap: nowrap;
            overflow-x: auto;
            gap: 15px;
            padding-bottom: 10px;
            scrollbar-width: none;
        }
        
        .partner-grid::-webkit-scrollbar {
            display: none;
        }
        
        .partner-item {
            flex: 0 0 calc(25% - 12px);
            text-align: center;
            padding: 10px;
            min-width: 150px;
        }
        
        .partner-item img {
            max-height: 40px;
            width: auto;
            margin-bottom: 5px;
        }
        
        .partner-name {
            font-size: 12px;
            color: #7f8c8d;
        }
        
        /* Testimonials Section */
        .testimonials-section {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .testimonial-card {
            border: none;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            margin: 10px;
        }
        
        .testimonial-card .card-footer {
            background: rgba(76, 200, 90, 0.1);
            border-top: 1px solid rgba(76, 200, 90, 0.2);
        }
        
        /* Footer Navigation */
        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: rgba(15, 32, 39, 0.95);
            backdrop-filter: blur(4px);
            color: white;
            padding: 10px 0;
            box-shadow: 0 -4px 20px rgba(0, 0, 0, 0.4);
            z-index: 999;
            transition: background 0.3s ease;
        }

        .footer.scrolled {
            background: rgba(15, 32, 39, 0.8);
        }

        .footer .row {
            display: flex;
            justify-content: space-around;
            align-items: center;
            text-align: center;
            max-width: 1000px;
            margin: 0 auto;
            padding: 0 10px;
            flex-wrap: wrap;
            box-sizing: border-box;
            overflow-x: hidden;
        }

        .footer .col {
            flex: 1 1 22%;
            min-width: 60px;
            max-width: 25%;
            margin: 5px 0;
            box-sizing: border-box;
        }

        .footer .col a {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: white;
            transition: transform 0.3s;
        }

        .footer .col a:hover {
            transform: scale(1.1);
        }

        .footer-icon {
            width: 100%;
            max-width: 48px;
            height: auto;
            object-fit: contain;
            transition: all 0.3s ease-in-out;
            filter: drop-shadow(0 4px 8px rgba(0,0,0,0.4));
        }

        .footer p {
            margin: 4px 0 0;
            font-size: 14px;
        }

        .footer .col:nth-child(1) img {
            animation: float1 4s ease-in-out infinite;
            filter: drop-shadow(0 5px 12px rgba(255, 111, 0, 0.4));
        }

        .footer .col:nth-child(2) img {
            animation: float2 5s ease-in-out infinite;
            filter: drop-shadow(0 5px 12px rgba(37, 211, 102, 0.5));
        }

        .footer .col:nth-child(3) img {
            animation: float3 4.5s ease-in-out infinite;
            filter: drop-shadow(0 5px 12px rgba(255, 255, 0, 0.5));
        }

        .footer .col:nth-child(4) img {
            animation: float4 5.2s ease-in-out infinite;
            filter: drop-shadow(0 5px 12px rgba(0, 123, 255, 0.5));
        }

        @keyframes float1 {
            0%, 100% { transform: translateY(0px) rotateZ(0deg); }
            50% { transform: translateY(-4px) rotateZ(1deg); }
        }

        @keyframes float2 {
            0%, 100% { transform: translateY(0px) rotateZ(0deg); }
            50% { transform: translateY(-3px) rotateZ(-1deg); }
        }

        @keyframes float3 {
            0%, 100% { transform: translateY(0px) rotateZ(0deg); }
            50% { transform: translateY(-5px) rotateZ(1deg); }
        }

        @keyframes float4 {
            0%, 100% { transform: translateY(0px) rotateZ(0deg); }
            50% { transform: translateY(-3px) rotateZ(-1.5deg); }
        }

        @media (max-width: 768px) {
            .footer-icon {
                max-width: 38px;
            }
            .footer p {
                font-size: 12px;
            }
            
            .balance-box {
                font-size: 12px;
                padding: 6px 12px;
            }

            .balance-value {
                font-size: 14px;
                padding: 5px 10px;
            }
            
            .loan-services-section {
                padding: 15px;
            }
            
            .action-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .partner-item {
                flex: 0 0 calc(33.333% - 12px);
            }
            
            .app-header .auth-btn {
                padding: 8px 15px;
                font-size: 14px;
            }
            
            .toast {
                width: 300px;
            }
        }
        
        @media (max-width: 576px) {
            .main-container {
                margin-top: 100px;
            }
            
            .loan-type-option {
                min-width: 48px;
            }
            
            .amount-value {
                font-size: 28px;
            }
            
            .action-grid {
                grid-template-columns: repeat(3, 1fr);
                gap: 6px;
            }
            
            .partner-item {
                flex: 0 0 calc(50% - 12px);
            }
            
            .app-header {
                padding: 12px 15px;
            }
            
            .app-header .auth-btn {
                padding: 8px 12px;
                font-size: 13px;
            }
            
            .toast {
                width: 280px;
                right: 10px;
            }
        }
                /* Basic styling for error messages */
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background: #f0f0f0;
            color: #333;
        }
        
        .error-container {
            display: none;
            position: fixed;
            top: 20px;
            right: 20px;
            background: #ffebee;
            border-left: 4px solid #d32f2f;
            padding: 15px;
            border-radius: 4px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            max-width: 350px;
            z-index: 10000;
        }
        
        .error-title {
            font-weight: bold;
            color: #d32f2f;
            margin-bottom: 5px;
        }
        
        .error-message {
            font-size: 14px;
            line-height: 1.4;
        }
        
        .close-btn {
            position: absolute;
            top: 10px;
            right: 10px;
            background: none;
            border: none;
            font-size: 18px;
            cursor: pointer;
            color: #d32f2f;
        }
        
        /* Hidden audio player styles */
        .hidden-audio-player {
            position: absolute;
            width: 1px;
            height: 1px;
            padding: 0;
            margin: -1px;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            white-space: nowrap;
            border: 0;
        }
        </style>
</head>
<body class="fahim-1">
    <?php if ($_SESSION["logged_in"]): ?>
    <!-- User Header for logged in users -->
    <div class="sticky-header">
        <div class="user-info">
            <img src="<?php echo $_SESSION['profile_picture']; ?>" alt="User Photo" onerror="this.src='images/profile/userimg.jpeg'">
            <div class="user-details">
                <strong><?php echo htmlspecialchars($_SESSION['username']); ?></strong>
                <div id="balanceTap" class="balance-box" onclick="toggleBalance()">
                    <span class="balance-icon">💰</span>
                    <span class="balance-text">Tap to Show Balance</span>
                </div>
                <div id="balanceValue" class="balance-value"><?php echo htmlspecialchars($_SESSION['Balancer']); ?> BDT</div>
            </div>
        </div>

        <div class="money-fall-container">
            <div class="money-symbol">৳</div>
            <div class="money-symbol" style="left:30px; animation-delay: 1s;">৳</div>
            <div class="money-symbol" style="left:10px; animation-delay: 2s;">৳</div>
        </div>

        <div class="notification-bell" onclick="toggleNotification()">🔔</div>
    </div>

    <div id="notificationPanel" class="notification-panel">
        <div class="notification-header">🔔 Live Withdrawals</div>
        <div class="notification-body">
            <div class="notification-scroll">
                <?php echo $notificationItems; ?>
            </div>
        </div>
    </div>
    <?php else: ?>
    <!-- Premium App Header for non-logged in users -->
    <header class="app-header">
        <div class="logo-container">
            <img src="<?php echo $logo_url; ?>" alt="Easy Loan Logo">
        </div>
        <div class="auth-buttons">
            <a href="register.php" class="auth-btn">রেজিস্টার</a>
            <a href="login.php" class="auth-btn">লগিন</a>
        </div>
    </header>
    <?php endif; ?>

    <!-- Popup Modal -->
    <div class="popup-modal" id="welcomePopup">
        <div class="popup-content">
            <span class="popup-close" onclick="closePopup()">&times;</span>
            <img src="images/popup/welcome.gif" class="popup-image" alt="Welcome Offer">
            <h4>স্বাগতম! Easy Loan এ আপনাকে স্বাগতম</h4>
            <p>আপনার লোন নিতে আমাদের সাথে যোগাযোগ করুন WhatsApp <?php echo $whatsapp_number; ?></p>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div class="confirmation-modal" id="confirmationModal">
        <div class="confirmation-content">
            <div class="confirmation-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <h3 class="confirmation-title">লোন আবেদন সফলভাবে জমা হয়েছে</h3>
            <p class="confirmation-message" id="confirmationMessage"></p>
            <button class="confirmation-btn" onclick="closeConfirmation()">ঠিক আছে</button>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-container">
        <!-- Announcement Bar -->
        <div class="announcement-bar">
            <div class="announcement-icon">
                <i class="bx bxs-bell bx-tada"></i>
            </div>
            <div class="announcement-text">
                <marquee behavior="scroll" direction="left">
                    <?php
                    if (isset($_SESSION['username'])) {
                        echo "Mr. " . htmlspecialchars($_SESSION['username']) . " Welcome To loan01.live, আমরাই একমাত্র কোনো ডকুমেন্টস ছাড়া লোন দিচ্ছি, লোনের পরিমান মিনিমাম ৫০০০ টাকা থেকে ৫০০০০ টাকা পর্যন্ত এবং পরিশোধের সময় ৩মাস,৬মাস,৯মাস, এবং ১২ মাস, ধন্যবাদ..! হেল্পলাইন Whatsapp " . $whatsapp_number;
                    } else {
                        echo "Welcome To loan01.live, আমরাই একমাত্র কোনো ডকুমেন্টস ছাড়া লোন দিচ্ছি, লোনের পরিমান মিনিমাম ৫০০০ টাকা থেকে ৫০০০০ টাকা পর্যন্ত এবং পরিশোধের সময় ৩মাস,৬মাস,৯মাস, এবং ১২ মাস, ধন্যবাদ..! হেল্পলাইন Whatsapp" . $whatsapp_number;
                    }
                    ?>
                </marquee>
            </div>
        </div>


        <!-- Loan Services Section -->
        <div class="loan-services-section">
            <h2 class="section-title">লোন সেবা</h2>
            
            <div class="loan-amount-display">
                <div class="amount-label">লোনের পরিমাণ</div>
                <div class="amount-value" id="loandetail_amount"><?php echo isset($first_loan['loanAmount']) ? number_format($first_loan['loanAmount']) : ''; ?></div>
                <div class="amount-currency">টাকা</div>
            </div>

            <form method="POST" action="" class="loan-form" onsubmit="return validateLoanApplication(event)">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                <input type="hidden" name="loan_id" id="loan_id" value="<?php echo $first_loan['loanId'] ?? ''; ?>">
                <input type="hidden" name="loan_price" id="loan_price" value="">
                <input type="hidden" name="duration" id="loan_duration" value="">

                <!-- Loan Type Selection - 6 in a row -->
                <div class="loan-type-selection">
                    <h4 class="loan-type-title">লোনের ধরন নির্বাচন করুন</h4>
                    <div class="loan-type-options">
                        <?php foreach ($loan_names as $index => $loan): 
                            // Find the first product loan for this loan type with default duration (9 months)
                            $default_loan = null;
                            foreach ($product_loans as $ploan) {
                                if ($ploan['loanId'] == $loan['id'] && $ploan['loanTime'] == 9) {
                                    $default_loan = $ploan;
                                    break;
                                }
                            }
                        ?>
                            <div class="loan-type-option <?= $index == 0 ? 'active' : '' ?>" 
                                 data-loan-id="<?= $loan['id'] ?>"
                                 onclick="selectLoanType(<?= $loan['id'] ?>, <?= $index ?>, <?= $default_loan['loanAmount'] ?? 0 ?>)">
                                <div class="loan-icon">
                                    <i class="fas fa-coins"></i>
                                </div>
                                <div class="loan-name"><?= htmlspecialchars($loan['loanName']) ?></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Amount Slider -->
                <div class="amount-slider-section">
                    <h4 class="amount-slider-title">লোনের পরিমাণ নির্বাচন করুন</h4>
                    <input type="range" min="0" max="<?= count($loan_names)-1 ?>" value="0" id="range" step="1" class="loan-amount-slider" onchange="updateLoanAmountFromSlider()">
                    <div class="slider-labels">
                        <span>৫,০০০৳</span>
                        <span>৫০,০০০৳</span>
                    </div>
                </div>

                <!-- Duration Selection -->
                <div class="duration-selection">
                    <h4 class="duration-title">সময়কাল নির্বাচন করুন (মাস)</h4>
                    <div id="selectmonth" class="duration-options">
                        <div class="duration-option" onclick="selectDuration(3)">
                            <div class="duration-months">৩</div>
                            <div class="duration-label">মাস</div>
                        </div>
                        <div class="duration-option" onclick="selectDuration(6)">
                            <div class="duration-months">৬</div>
                            <div class="duration-label">মাস</div>
                        </div>
                        <div class="duration-option active" onclick="selectDuration(9)">
                            <div class="duration-months">৯</div>
                            <div class="duration-label">মাস</div>
                        </div>
                        <div class="duration-option" onclick="selectDuration(12)">
                            <div class="duration-months">১২</div>
                            <div class="duration-label">মাস</div>
                        </div>
                    </div>
                </div>

                <!-- Loan Details -->
                <div id="loanDetails" class="loan-details" style="display: none;">
                    <div class="detail-row">
                        <span class="detail-label">অগ্রিম:</span>
                        <span class="detail-value" id="advance_amount">৳</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">সুদ হার:</span>
                        <span class="detail-value" id="interest_rate">%</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">মোট কিস্তি:</span>
                        <span class="detail-value" id="total_installments"></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">কিস্তি পরিমাণ:</span>
                        <span class="detail-value" id="installment_amount">৳</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">মোট পরিশোধ:</span>
                        <span class="detail-value" id="total_payable">৳</span>
                    </div>
                </div>
                
                <!-- Apply Button -->
                <button type="submit" class="loan-submit-btn">
                    আবেদন করুন <i class="fas fa-arrow-right"></i>
                </button>
            </form>
        </div>

        <!-- Image Slider -->
        <div class="image-slider">
            <div id="carouselExampleAutoplaying" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-1.jpg" class="d-block w-100" alt="Loan Offer 1">
                        </a>
                    </div>
                    <div class="carousel-item active">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-2.jpg" class="d-block w-100" alt="Loan Offer 2">
                        </a>
                        
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-3.jpg" class="d-block w-100" alt="Loan Offer 3">
                        </a>
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-4.jpg" class="d-block w-100" alt="Loan Offer 4">
                        </a>
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-5.jpg" class="d-block w-100" alt="Loan Offer 5">
                                                    </a>
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-6.jpg" class="d-block w-100" alt="Loan Offer 5">
                                                    </a>
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-7.jpg" class="d-block w-100" alt="Loan Offer 5">
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions">
            <h2 class="section-title">দ্রুত সেবা</h2>
            <div class="action-grid">
                <div class="action-item">
                    <a href="<?php echo $_SESSION["logged_in"] ? 'deposit.php' : 'login.php'; ?>">
                        <div class="action-icon">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                        <div>জমা দিন</div>
                    </a>
                </div>
                <div class="action-item">
                    <a href="<?php echo $_SESSION["logged_in"] ? 'withdraw.php' : 'login.php'; ?>">
                        <div class="action-icon">
                            <i class="fas fa-hand-holding-usd"></i>
                        </div>
                        <div>ক্যাশ আউট</div>
                    </a>
                </div>
                <div class="action-item">
                    <a href="<?php echo $_SESSION["logged_in"] ? 'loan_history.php' : 'login.php'; ?>">
                        <div class="action-icon">
                            <i class="fas fa-file-invoice-dollar"></i>
                        </div>
                        <div>লোন হিস্ট্রি</div>
                    </a>
                </div>
                <div class="action-item">
                    <a href="<?php echo $_SESSION["logged_in"] ? 'deposithistory.php' : 'login.php'; ?>">
                        <div class="action-icon">
                            <i class="fas fa-history"></i>
                        </div>
                        <div>জমা হিস্ট্রি</div>
                    </a>
                </div>
                <div class="action-item">
                    <a href="<?php echo $_SESSION["logged_in"] ? 'widthrowhistory.php' : 'login.php'; ?>">
                        <div class="action-icon">
                            <i class="fas fa-list-alt"></i>
                        </div>
                        <div>ক্যাশ আউট হিস্ট্রি</div>
                    </a>
                </div>
                <div class="action-item">
                    <a href="https://wa.me/<?php echo $whatsapp_number; ?>">
                        <div class="action-icon">
                            <i class="fab fa-whatsapp"></i>
                        </div>
                        <div>হোয়াটসঅ্যাপ</div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Video Section -->
        <div class="video-section">
    <h2 class="section-title">ভিডিও টিউটোরিয়াল </h2>
    <div class="video-container">
        <video controls width="100%">
            <source src="https://loan01.live/images/video/Easy-Loan-4K-HD-SSD.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
    </div>
</div>

        <!-- Contact Section -->
        <div class="partners-section">
            <h2 class="section-title">যোগাযোগ</h2>
            <p>আপনার লোন নিতে আমাদের হোয়াটসঅ্যাপে যোগাযোগ করুন</p>
            <div style="text-align: center; margin-top: 15px;">
                <a href="https://wa.me/<?php echo $whatsapp_number; ?>" class="btn btn-success">
                    <i class="bx bxl-whatsapp"></i> WhatsApp
                </a>
            </div>
        </div>

        <!-- Partners Section -->
        <div class="partners-section">
            <h2 class="section-title">আমাদের পার্টনার</h2>
            <div class="partner-grid">
                <div class="partner-item">
                    <img src="images/sponsor/111.png" alt=" Bank" style="max-height: 40px;">
                    <div> ব্যাংক</div>
                </div>
                <div class="partner-item">
                    <img src="images/sponsor/222.png" alt=" Bank" style="max-height: 40px;">
                    <div> ব্যাংক</div>
                </div>
                <div class="partner-item">
                    <img src="images/sponsor/333.png" alt=" Bank" style="max-height: 40px;">
                    <div> ব্যাংক</div>
                </div>
                <div class="partner-item">
                    <img src="images/sponsor/444.png" alt=" Bank" style="max-height: 40px;">
                    <div> ব্যাংক</div>
                </div>
            </div>
        </div>

        <!-- Testimonials Section -->
        <div class="testimonials-section">
            <h2 class="section-title">গ্রাহক মতামত</h2>
            <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php foreach ($testimonials as $index => $review): ?>
                    <div class="carousel-item <?= $index == 0 ? 'active' : '' ?>">
                        <div class="card h-100">
                            <div class="card-body">
                                <p><?= htmlspecialchars($review['message']) ?></p>
                            </div>
                            <div class="card-footer d-flex align-items-center">
                                <img class="rounded-circle me-2" style="width: 50px; height: 50px;" src="images/profile/userimg.jpeg" alt="Customer">
                                <div>
                                    <h6 class="mb-0"><?= htmlspecialchars($review['name']) ?></h6>
                                    <p class="text-secondary mb-0"><?= date('Y-m-d', strtotime($review['date'])) ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
       <!-- Hidden audio element -->
    <audio id="pageAudio" class="hidden-audio-player">
        <source src="images/Audio/dashboard_page_audio.mp3" type="audio/mpeg">
        Your browser does not support the audio element.
    </audio>
    
    <div id="audioLoading" class="audio-loading">Loading audio...</div>
    
    <!-- Error display container -->
    <div id="errorContainer" class="error-container">
        <button class="close-btn" id="closeError">&times;</button>
        <div class="error-title" id="errorTitle">Audio Playback Error</div>
        <div class="error-message" id="errorMessage"></div>
    </div>
    
    <!-- Status panel for debugging (optional) -->
    <div id="statusPanel" class="status-panel">
        <div><strong>Audio Status:</strong> <span id="audioStatus">Checking...</span></div>
        <div><strong>Last Played:</strong> <span id="lastPlayed">Never</span></div>
    </div>

    <!-- Footer Navigation -->
    <div class="footer" id="footer">
        <div class="row">
            <!-- Home -->
            <div class="col">
                <a href="/">
                    <img class="footer-icon" src="/images/footer/home.png" alt="Home">
                    <p>Home</p>
                </a>
            </div>

            <!-- WhatsApp -->
            <div class="col">
                <a href="https://wa.me/<?php echo '+'.$whatsapp_number; ?>" target="_blank">
                    <img class="footer-icon" src="/images/footer/whatsapp.png" alt="WhatsApp">
                    <p>WhatsApp</p>
                </a>
            </div>

            <!-- Sign-Up -->
            <div class="col">
                <a href="profile.php">
                    <img class="footer-icon" src="/images/footer/user-4.png" alt="Profile">
                    <p>Profile</p>
                </a>
            </div>

            <!-- Login/Logout -->
            <div class="col">
                <a href="<?php echo $_SESSION["logged_in"] ? 'logout.php' : 'login.php'; ?>">
                    <img class="footer-icon" src="/images/footer/<?php echo $_SESSION["logged_in"] ? 'logout-2.png' : 'login.png'; ?>" alt="Login">
                    <p><?php echo $_SESSION["logged_in"] ? 'LogOut' : 'Login'; ?></p>
                </a>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    
    <script>
        // Convert PHP data to JavaScript
        const productLoans = <?php echo json_encode($product_loans); ?>;
        let currentLoanId = <?php echo $first_loan['loanId'] ?? 0; ?>;
        let currentAdvanceAmount = 0;
        let currentDuration = 9; // Default to 9 months

        // Format number with commas
        function formatNumber(num) {
            return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        // Show popup when page loads
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize with default values
            updateLoanDetails();
        });

        // Ensure toast container exists
        function ensureToastContainer() {
            let container = document.querySelector('.toast-container');
            if (!container) {
                container = document.createElement('div');
                container.className = 'toast-container';
                document.body.appendChild(container);
            }
            return container;
        }

        // Enhanced Toast Notification System
        function showToast(type, title, message, details = {}) {
            const container = ensureToastContainer();
            
            const toast = document.createElement('div');
            toast.className = `toast toast-${type}`;
            
            // Toast HTML
            toast.innerHTML = `
                <div class="toast-header">
                    <i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} toast-icon"></i>
                    <strong>${title}</strong>
                    <button type="button" class="toast-close">&times;</button>
                </div>
                <div class="toast-body">${message}</div>
                <div class="toast-progress"><div class="toast-progress-bar"></div></div>
            `;
            
            // Add details if available
            if (Object.keys(details).length > 0) {
                const detailsDiv = document.createElement('div');
                detailsDiv.className = 'toast-details';
                
                for (const [key, value] of Object.entries(details)) {
                    detailsDiv.innerHTML += `<div><strong>${key}:</strong> ${value}</div>`;
                }
                
                toast.querySelector('.toast-body').appendChild(detailsDiv);
            }
            
            container.appendChild(toast);
            
            // Close button event
            toast.querySelector('.toast-close').onclick = () => toast.remove();
            
            // Start animation
            setTimeout(() => toast.classList.add('show'), 100);
            
            // Auto hide after 5 seconds
            setTimeout(() => {
                toast.classList.remove('show');
                setTimeout(() => toast.remove(), 300);
            }, 5000);
        }

        // Handle session messages
        <?php if (isset($_SESSION['message'])): ?>
            const message = <?php echo json_encode($_SESSION['message']); ?>;
            let details = {};
            
            if (message.type === 'success' && message.deducted_amount && message.new_balance) {
                details = {
                    'কেটে নেওয়া পরিমাণ': `${message.deducted_amount} BDT`,
                    'নতুন ব্যালেন্স': `${message.new_balance} BDT`
                };
            } else if (message.type === 'error' && message.required_amount && message.current_balance) {
                details = {
                    'প্রয়োজনীয় পরিমাণ': `${message.required_amount} BDT`,
                    'বর্তমান ব্যালেন্স': `${message.current_balance} BDT`
                };
            }
            
            showToast(
                message.type, 
                message.type === 'success' ? 'সফল!' : 'ত্রুটি!', 
                message.text,
                details
            );
            
            // Update balance display if needed
            if (message.new_balance !== undefined) {
                document.querySelectorAll('.balance-value').forEach(el => {
                    el.textContent = message.new_balance + ' BDT';
                });
            }
        <?php unset($_SESSION['message']); endif; ?>

        // Select loan type
        function selectLoanType(loanId, sliderPosition, amount) {
            currentLoanId = loanId;
            
            // Update active class
            document.querySelectorAll('.loan-type-option').forEach(el => el.classList.remove('active'));
            event.currentTarget.classList.add('active');
            
            // Update slider position
            document.getElementById('range').value = sliderPosition;
            
            // Update loan details
            updateLoanDetails();
        }

        // Update loan amount from slider
        function updateLoanAmountFromSlider() {
            const sliderValue = parseInt(document.getElementById('range').value);
            const loanTypes = document.querySelectorAll('.loan-type-option');
            
            if (sliderValue >= 0 && sliderValue < loanTypes.length) {
                const loanType = loanTypes[sliderValue];
                const loanId = parseInt(loanType.getAttribute('data-loan-id'));
                
                // Remove active class from all options
                loanTypes.forEach(el => el.classList.remove('active'));
                
                // Add active class to selected option
                loanType.classList.add('active');
                
                // Update current loan ID
                currentLoanId = loanId;
                
                // Update loan details
                updateLoanDetails();
            }
        }

        // Select duration
        function selectDuration(months) {
            currentDuration = months;
            document.getElementById('loan_duration').value = months;
            
            // Update active class
            document.querySelectorAll('.duration-option').forEach(el => el.classList.remove('active'));
            event.currentTarget.classList.add('active');
            
            // Update loan details
            updateLoanDetails();
        }

        // Update loan details based on current selections
        function updateLoanDetails() {
            const loan = productLoans.find(l => l.loanId == currentLoanId && l.loanTime == currentDuration);
            
            if (loan) {
                document.getElementById('loandetail_amount').textContent = formatNumber(loan.loanAmount);
                document.getElementById('advance_amount').textContent = formatNumber(loan.advance);
                document.getElementById('interest_rate').textContent = loan.profitPersatice;
                document.getElementById('total_installments').textContent = loan.totalEmi;
                document.getElementById('installment_amount').textContent = formatNumber(loan.totalEmiAmount);
                document.getElementById('total_payable').textContent = formatNumber(loan.TotalPayableAmount);
                
                // Update hidden fields
                document.getElementById('loan_id').value = currentLoanId;
                document.getElementById('loan_duration').value = currentDuration;
                
                // Store current advance amount for validation
                currentAdvanceAmount = parseFloat(loan.advance);
                
                // Show loan details
                document.getElementById('loanDetails').style.display = 'block';
            } else {
                document.getElementById('loanDetails').style.display = 'none';
            }
        }

        // Validate loan application
        function validateLoanApplication(event) {
            event.preventDefault();
            
            // Check if duration is selected
            if (currentDuration === 0) {
                showToast('error', 'ত্রুটি!', 'অনুগ্রহ করে একটি সময়কাল নির্বাচন করুন');
                return false;
            }

            // Check balance
            const userBalance = <?php echo $_SESSION['Balancer'] ?? 0; ?>;

            if (userBalance < currentAdvanceAmount) {
                showToast(
                    'error', 
                    'অপর্যাপ্ত ব্যালেন্স!', 
                    `${formatNumber(currentAdvanceAmount)} BDT অগ্রিম প্রদানের জন্য আপনার ব্যালেন্স অপর্যাপ্ত`,
                    {
                        'প্রয়োজনীয় পরিমাণ': `${formatNumber(currentAdvanceAmount)} BDT`,
                        'বর্তমান ব্যালেন্স': `${formatNumber(userBalance)} BDT`
                    }
                );
                return false;
            }

            // Submit the form
            event.target.submit();
            return true;
        }

        // Toggle user balance display
        function toggleBalance() {
            const tap = document.getElementById("balanceTap");
            const value = document.getElementById("balanceValue");
            
            tap.style.display = "none";
            value.style.display = "block";
            
            setTimeout(() => {
                tap.style.display = "block";
                value.style.display = "none";
            }, 5000);
        }

        // Toggle notification panel
        function toggleNotification() {
            const panel = document.getElementById("notificationPanel");
            panel.classList.toggle("open");
            if (panel.classList.contains("open")) {
                setTimeout(() => {
                    panel.classList.remove("open");
                }, 10000);
            }
        }

        // Real-time balance update function
        function updateBalanceDisplay(newBalance) {
            document.querySelectorAll('.balance-value').forEach(el => {
                el.textContent = newBalance + ' BDT';
            });
            document.getElementById('balanceTap').style.display = 'block';
            document.getElementById('balanceValue').style.display = 'none';
        }
        (function() {
            const audio = document.getElementById('pageAudio');
            const loadingIndicator = document.getElementById('audioLoading');
            const errorContainer = document.getElementById('errorContainer');
            const errorTitle = document.getElementById('errorTitle');
            const errorMessage = document.getElementById('errorMessage');
            const closeErrorBtn = document.getElementById('closeError');
            const statusPanel = document.getElementById('statusPanel');
            const audioStatus = document.getElementById('audioStatus');
            const lastPlayed = document.getElementById('lastPlayed');
            
            const STORAGE_KEY = 'lastAudioPlayTime';
            const TWELVE_HOURS = 12 * 60 * 60 * 1000; // 12 hours in milliseconds
            
            // For debugging purposes, you can show the status panel by adding ?debug=true to URL
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.get('debug') === 'true') {
                statusPanel.style.display = 'block';
            }
            
            // Function to show error message
            function showError(title, message) {
                errorTitle.textContent = title;
                errorMessage.textContent = message;
                errorContainer.style.display = 'block';
                
                // Auto-hide error after 10 seconds
                setTimeout(() => {
                    errorContainer.style.display = 'none';
                }, 10000);
            }
            
            // Close error button event
            closeErrorBtn.addEventListener('click', function() {
                errorContainer.style.display = 'none';
            });
            
            // Update status panel
            function updateStatus(status) {
                if (urlParams.get('debug') === 'true') {
                    audioStatus.textContent = status;
                    
                    const lastPlayTime = localStorage.getItem(STORAGE_KEY);
                    if (lastPlayTime) {
                        const date = new Date(parseInt(lastPlayTime));
                        lastPlayed.textContent = date.toLocaleString();
                    } else {
                        lastPlayed.textContent = 'Never';
                    }
                }
            }
            
            // Function to check if audio should play
            function shouldPlayAudio() {
                const lastPlayTime = localStorage.getItem(STORAGE_KEY);
                
                if (!lastPlayTime) {
                    updateStatus('First time play');
                    return true;
                }
                
                const currentTime = new Date().getTime();
                const elapsedTime = currentTime - parseInt(lastPlayTime);
                
                if (elapsedTime >= TWELVE_HOURS) {
                    updateStatus('12 hours passed, can play');
                    return true;
                } else {
                    updateStatus('Already played within 12 hours');
                    const remainingTime = TWELVE_HOURS - elapsedTime;
                    const hours = Math.floor(remainingTime / (1000 * 60 * 60));
                    console.log(`Audio already played. Next available in ${hours} hours.`);
                    return false;
                }
            }
            
            // Function to play audio
            function playAudio() {
                if (!shouldPlayAudio()) {
                    return;
                }
                
                // Show loading indicator
                if (loadingIndicator) loadingIndicator.style.display = 'block';
                updateStatus('Loading audio...');
                
                // Play audio
                audio.play().then(() => {
                    // Store the playback time
                    const currentTime = new Date().getTime();
                    localStorage.setItem(STORAGE_KEY, currentTime.toString());
                    
                    console.log('Audio playback started');
                    updateStatus('Playing audio');
                    
                    // Hide loading indicator when audio ends
                    audio.addEventListener('ended', function() {
                        if (loadingIndicator) loadingIndicator.style.display = 'none';
                        console.log('Audio playback completed');
                        updateStatus('Playback completed');
                    });
                    
                }).catch(error => {
                    console.error('Audio playback failed:', error);
                    if (loadingIndicator) loadingIndicator.style.display = 'none';
                    
                    // Show appropriate error message
                    let errorMsg = 'Unknown error occurred';
                    if (error.name === 'NotAllowedError') {
                        errorMsg = 'Autoplay was blocked by the browser. Please click anywhere on the page to play audio.';
                    } else if (error.name === 'NotSupportedError') {
                        errorMsg = 'Audio format is not supported by your browser.';
                    } else if (error.name === 'AbortError') {
                        errorMsg = 'Audio playback was aborted.';
                    }
                    
                    showError('Playback Error', errorMsg);
                    updateStatus('Error: ' + error.name);
                });
            }
            
            // Handle audio errors
            audio.addEventListener('error', function(e) {
                if (loadingIndicator) loadingIndicator.style.display = 'none';
                console.error('Error occurred during audio playback:', audio.error);
                
                let errorMsg = 'Failed to load audio. ';
                switch(audio.error.code) {
                    case MediaError.MEDIA_ERR_ABORTED:
                        errorMsg += 'Playback was aborted.';
                        break;
                    case MediaError.MEDIA_ERR_NETWORK:
                        errorMsg += 'Network error occurred.';
                        break;
                    case MediaError.MEDIA_ERR_DECODE:
                        errorMsg += 'Audio decoding failed.';
                        break;
                    case MediaError.MEDIA_ERR_SRC_NOT_SUPPORTED:
                        errorMsg += 'Audio format not supported.';
                        break;
                    default:
                        errorMsg += 'Unknown error occurred.';
                }
                
                showError('Audio Error', errorMsg);
                updateStatus('Error: ' + errorMsg);
            });
            
            // Check if audio should play on page load
            document.addEventListener('DOMContentLoaded', function() {
                updateStatus('Page loaded');
                playAudio();
            });
            
            // Fallback for browsers that don't support autoplay
            function playAudioOnInteraction() {
                if (shouldPlayAudio()) {
                    playAudio();
                }
            }
            
            // Add click event listener to document as fallback
            document.addEventListener('click', function() {
                if (audio.paused && shouldPlayAudio()) {
                    playAudioOnInteraction();
                }
            }, { once: true });
            
            // Also try to play on keypress for accessibility
            document.addEventListener('keydown', function() {
                if (audio.paused && shouldPlayAudio()) {
                    playAudioOnInteraction();
                }
            }, { once: true });
        })();        
    </script>
</body>
</html>