<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

// Admin login check
if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location:../login.php");
    exit();
}

include('includes/connect.php');

// Get user ID from URL and validate
$uid = isset($_GET['id']) ? intval($_GET['id']) : null;
if (!$uid) {
    $_SESSION['status'] = "Invalid user ID";
    header("Location: users.php");
    exit();
}

// Account status update logic
if (isset($_GET['action']) && isset($_GET['user_id'])) {
    $user_id = intval($_GET['user_id']);
    if ($user_id === $uid) {
        $new_status = ($_GET['action'] === 'activate') ? 'active' : 'inactive';
        
        $update_sql = "UPDATE user SET account_status = '$new_status' WHERE id = $user_id";
        if (mysqli_query($conn, $update_sql)) {
            $_SESSION['status'] = "User status updated successfully!";
        } else {
            $_SESSION['status'] = "Error updating status: " . mysqli_error($conn);
        }
        header("Location: useractions.php?id=".$uid);
        exit();
    }
}

// Fetch user data securely
$userData = [];
$stmt = $conn->prepare("SELECT * FROM user WHERE id = ?");
$stmt->bind_param("i", $uid);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    $_SESSION['status'] = "User not found";
    header("Location: users.php");
    exit();
}

$userData = $result->fetch_assoc();

// Fetch loan history for this user
$loanHistory = [];
$loanStmt = $conn->prepare("
    SELECT * FROM loan_applications 
    WHERE user_id = ? 
    ORDER BY application_date DESC
");
$loanStmt->bind_param("i", $uid);
$loanStmt->execute();
$loanResult = $loanStmt->get_result();

if ($loanResult->num_rows > 0) {
    while($loan = $loanResult->fetch_assoc()) {
        $loanHistory[] = $loan;
    }
}

// Fetch loan payments for this user
$loanPayments = [];
$paymentStmt = $conn->prepare("
    SELECT * FROM loan_payments 
    WHERE user_id = ? 
    ORDER BY payment_date DESC
");
$paymentStmt->bind_param("i", $uid);
$paymentStmt->execute();
$paymentResult = $paymentStmt->get_result();

if ($paymentResult->num_rows > 0) {
    while($payment = $paymentResult->fetch_assoc()) {
        $loanPayments[] = $payment;
    }
}

// Fetch deposits for this user
$deposits = [];
$depositStmt = $conn->prepare("
    SELECT * FROM deposits 
    WHERE userid = ? 
    ORDER BY created_at DESC
");
$depositStmt->bind_param("i", $uid);
$depositStmt->execute();
$depositResult = $depositStmt->get_result();

if ($depositResult->num_rows > 0) {
    while($deposit = $depositResult->fetch_assoc()) {
        $deposits[] = $deposit;
    }
}

// Fetch withdrawals for this user
$withdrawals = [];
$withdrawalStmt = $conn->prepare("
    SELECT * FROM widthrow 
    WHERE userid = ? 
    ORDER BY time DESC
");
$withdrawalStmt->bind_param("i", $uid);
$withdrawalStmt->execute();
$withdrawalResult = $withdrawalStmt->get_result();

if ($withdrawalResult->num_rows > 0) {
    while($withdrawal = $withdrawalResult->fetch_assoc()) {
        $withdrawals[] = $withdrawal;
    }
}

// Function to get full URL
function getFullUrl($path) {
    if (empty($path)) return '';
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
    return $baseUrl . '/' . ltrim($path, '/');
}

// Handle image operations for THIS USER ONLY
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Verify that the operation is for this user
    $requestedUserId = isset($_POST['user_id']) ? intval($_POST['user_id']) : null;
    if ($requestedUserId !== $uid) {
        $_SESSION['status'] = "Unauthorized operation";
        header("Location: useractions.php?id=".$uid);
        exit();
    }

    // Handle profile picture update for THIS USER
    if (isset($_FILES['profile_picture']) && $_FILES['profile_picture']['error'] == 0) {
        $targetDir = "uploads/profile/";
        if (!file_exists($targetDir)) {
            mkdir($targetDir, 0777, true);
        }
        
        $fileExt = pathinfo($_FILES['profile_picture']['name'], PATHINFO_EXTENSION);
        $fileName = "profile_".$uid."_".time().".".$fileExt;
        $targetFilePath = $targetDir . $fileName;
        
        // Delete old file if exists
        if (!empty($userData['profile_picture']) && file_exists($userData['profile_picture'])) {
            unlink($userData['profile_picture']);
        }
        
        if (move_uploaded_file($_FILES['profile_picture']['tmp_name'], $targetFilePath)) {
            $update = $conn->prepare("UPDATE user SET profile_picture = ? WHERE id = ?");
            $update->bind_param("si", $targetFilePath, $uid);
            $update->execute();
            $_SESSION['status'] = "Profile picture updated successfully.";
            header("Location: useractions.php?id=".$uid);
            exit();
        }
    }

    // Handle NID front update for THIS USER
    if (isset($_FILES['nid_front']) && $_FILES['nid_front']['error'] == 0) {
        $targetDir = "uploads/nid/";
        if (!file_exists($targetDir)) {
            mkdir($targetDir, 0777, true);
        }
        
        $fileExt = pathinfo($_FILES['nid_front']['name'], PATHINFO_EXTENSION);
        $fileName = "nid_front_".$uid."_".time().".".$fileExt;
        $targetFilePath = $targetDir . $fileName;
        
        // Delete old file if exists
        if (!empty($userData['nid_front']) && file_exists($userData['nid_front'])) {
            unlink($userData['nid_front']);
        }
        
        if (move_uploaded_file($_FILES['nid_front']['tmp_name'], $targetFilePath)) {
            $update = $conn->prepare("UPDATE user SET nid_front = ? WHERE id = ?");
            $update->bind_param("si", $targetFilePath, $uid);
            $update->execute();
            $_SESSION['status'] = "NID front updated successfully.";
            header("Location: useractions.php?id=".$uid);
            exit();
        }
    }

    // Handle NID back update for THIS USER
    if (isset($_FILES['nid_back']) && $_FILES['nid_back']['error'] == 0) {
        $targetDir = "uploads/nid/";
        $fileExt = pathinfo($_FILES['nid_back']['name'], PATHINFO_EXTENSION);
        $fileName = "nid_back_".$uid."_".time().".".$fileExt;
        $targetFilePath = $targetDir . $fileName;
        
        // Delete old file if exists
        if (!empty($userData['nid_back']) && file_exists($userData['nid_back'])) {
            unlink($userData['nid_back']);
        }
        
        if (move_uploaded_file($_FILES['nid_back']['tmp_name'], $targetFilePath)) {
            $update = $conn->prepare("UPDATE user SET nid_back = ? WHERE id = ?");
            $update->bind_param("si", $targetFilePath, $uid);
            $update->execute();
            $_SESSION['status'] = "NID back updated successfully.";
            header("Location: useractions.php?id=".$uid);
            exit();
        }
    }

    // Handle image deletion for THIS USER
    if (isset($_POST['delete_image'])) {
        $imageType = $_POST['image_type'];
        $columnName = '';
        
        switch ($imageType) {
            case 'profile':
                $columnName = 'profile_picture';
                break;
            case 'nid_front':
                $columnName = 'nid_front';
                break;
            case 'nid_back':
                $columnName = 'nid_back';
                break;
        }

        if (!empty($columnName)) {
            // Delete file from server
            if (!empty($userData[$columnName]) && file_exists($userData[$columnName])) {
                unlink($userData[$columnName]);
            }

            // Update database for THIS USER ONLY
            $update = $conn->prepare("UPDATE user SET $columnName = NULL WHERE id = ?");
            $update->bind_param("i", $uid);
            $update->execute();
            
            $_SESSION['status'] = ucfirst(str_replace('_', ' ', $imageType))." deleted successfully.";
            header("Location: useractions.php?id=".$uid);
            exit();
        }
    }

    // Handle basic info update for THIS USER
    if (isset($_POST['update_info'])) {
        $phone = $_POST['mobile_number'];
        $username = $_POST['username'];
        $password = $_POST['password'];
        $Balancer = $_POST['Balancer'];
        $is_verified = isset($_POST['is_verified']) ? 1 : 0;

        $sql = "UPDATE user SET username = ?, mobile_number = ?, password = ?, Balancer = ?, is_verified = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssii", $username, $phone, $password, $Balancer, $is_verified, $uid);
        
        if ($stmt->execute()) {
            $_SESSION['status'] = "User information updated successfully.";
        } else {
            $_SESSION['status'] = "Error updating user information: ".$stmt->error;
        }
        
        header("Location: useractions.php?id=".$uid);
        exit();
    }
}

// Include header files
include('../admin/includes/header.php');
include('../admin/includes/topbar.php');
include('../admin/includes/sidebar.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .img-thumbnail {
            max-width: 200px;
            max-height: 200px;
            object-fit: cover;
            cursor: pointer;
        }
        .file-link {
            display: block;
            margin-top: 10px;
            word-break: break-all;
            font-size: 12px;
        }
        .copy-btn {
            cursor: pointer;
            background: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 3px;
            padding: 2px 5px;
            margin-left: 5px;
        }
        .image-container {
            position: relative;
            margin-bottom: 15px;
        }
        .alert {
            margin-bottom: 20px;
        }
        .loan-status-badge {
            font-size: 0.85rem;
            padding: 0.35em 0.65em;
        }
        .loan-card {
            border-left: 4px solid;
            transition: all 0.3s ease;
        }
        .loan-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .loan-approved {
            border-left-color: #198754;
        }
        .loan-pending {
            border-left-color: #ffc107;
        }
        .loan-rejected {
            border-left-color: #dc3545;
        }
        .loan-completed {
            border-left-color: #0dcaf0;
        }
        .loan-table th {
            background-color: #f8f9fa;
        }
        .tab-content {
            padding: 20px 0;
        }
        .nav-tabs .nav-link {
            border: none;
            border-bottom: 3px solid transparent;
            color: #6c757d;
            font-weight: 500;
        }
        .nav-tabs .nav-link.active {
            color: #0d6efd;
            border-bottom: 3px solid #0d6efd;
            background: transparent;
        }
        .stats-card {
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        .stats-card:hover {
            transform: translateY(-5px);
        }
        .stats-icon {
            font-size: 2.5rem;
            opacity: 0.8;
        }
        .account-status-badge {
            font-size: 1rem;
            padding: 0.5em 1em;
        }
    </style>
</head>
<body>
<main>
    <div class="container-fluid px-4">
        <h1 class="mt-4">User Management</h1>

        <div class="container mt-5">
            <!-- Status Message -->
            <?php if (isset($_SESSION['status'])): ?>
                <div class="alert alert-info alert-dismissible fade show">
                    <?php echo $_SESSION['status']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    <?php unset($_SESSION['status']); ?>
                </div>
            <?php endif; ?>

            <!-- User Summary Section -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card stats-card bg-primary text-white mb-4">
                        <div class="card-body text-center">
                            <i class="fas fa-wallet stats-icon"></i>
                            <h3>৳<?php echo number_format($userData['Balancer'], 2); ?></h3>
                            <p class="mb-0">Current Balance</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card stats-card bg-success text-white mb-4">
                        <div class="card-body text-center">
                            <i class="fas fa-file-invoice-dollar stats-icon"></i>
                            <h3><?php echo count($loanHistory); ?></h3>
                            <p class="mb-0">Total Loans</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card stats-card bg-info text-white mb-4">
                        <div class="card-body text-center">
                            <i class="fas fa-money-bill-wave stats-icon"></i>
                            <h3><?php echo count($deposits); ?></h3>
                            <p class="mb-0">Total Deposits</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card stats-card bg-warning text-white mb-4">
                        <div class="card-body text-center">
                            <i class="fas fa-hand-holding-usd stats-icon"></i>
                            <h3><?php echo count($withdrawals); ?></h3>
                            <p class="mb-0">Total Withdrawals</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Account Status Section -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Account Status - <?php echo htmlspecialchars($userData['username']); ?></h4>
                    <div>
                        <span class="badge account-status-badge <?php echo $userData['account_status'] === 'active' ? 'bg-success' : 'bg-danger'; ?>">
                            <?php echo ucfirst($userData['account_status']); ?>
                        </span>
                        <?php if ($userData['is_verified']): ?>
                            <span class="badge account-status-badge bg-info">Verified</span>
                        <?php else: ?>
                            <span class="badge account-status-badge bg-warning">Unverified</span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="d-flex gap-2">
                        <a href="useractions.php?id=<?php echo $uid; ?>&action=activate" 
                           class="btn btn-success <?php echo $userData['account_status'] === 'active' ? 'disabled' : ''; ?>">
                            <i class="fas fa-check-circle"></i> Activate Account
                        </a>
                        <a href="useractions.php?id=<?php echo $uid; ?>&action=deactivate" 
                           class="btn btn-danger <?php echo $userData['account_status'] === 'inactive' ? 'disabled' : ''; ?>">
                            <i class="fas fa-times-circle"></i> Deactivate Account
                        </a>
                    </div>
                </div>
            </div>

            <!-- Tabs Navigation -->
            <ul class="nav nav-tabs" id="userTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab">Profile</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="loans-tab" data-bs-toggle="tab" data-bs-target="#loans" type="button" role="tab">Loans</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="payments-tab" data-bs-toggle="tab" data-bs-target="#payments" type="button" role="tab">Payments</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="deposits-tab" data-bs-toggle="tab" data-bs-target="#deposits" type="button" role="tab">Deposits</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="withdrawals-tab" data-bs-toggle="tab" data-bs-target="#withdrawals" type="button" role="tab">Withdrawals</button>
                </li>
            </ul>

            <!-- Tabs Content -->
            <div class="tab-content" id="userTabsContent">
                
                <!-- Profile Tab -->
                <div class="tab-pane fade show active" id="profile" role="tabpanel">
                    <div class="card mb-4">
                        <div class="card-header bg-primary text-white">
                            <div class="d-flex justify-content-between align-items-center">
                                <h4 class="mb-0">User Profile - <?php echo htmlspecialchars($userData['username']); ?></h4>
                                <span class="badge bg-light text-dark">User ID: <?php echo $uid; ?></span>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <!-- Profile Picture Section -->
                                <div class="col-md-4 text-center">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5>Profile Picture</h5>
                                        </div>
                                        <div class="card-body">
                                            <?php if (!empty($userData['profile_picture'])): 
                                                $profilePicUrl = getFullUrl($userData['profile_picture']);
                                            ?>
                                                <div class="image-container">
                                                    <img src="<?php echo htmlspecialchars($profilePicUrl); ?>" 
                                                         class="img-thumbnail mb-2"
                                                         onclick="window.open('<?php echo htmlspecialchars($profilePicUrl); ?>', '_blank')"
                                                         alt="Profile Picture"
                                                         title="Click to view in new tab">
                                                </div>
                                                
                                                <div class="d-flex align-items-center">
                                                    <a href="<?php echo htmlspecialchars($profilePicUrl); ?>" 
                                                       target="_blank" 
                                                       class="file-link">
                                                       <?php echo htmlspecialchars($profilePicUrl); ?>
                                                    </a>
                                                    <button class="copy-btn" onclick="copyToClipboard('<?php echo htmlspecialchars($profilePicUrl); ?>')">
                                                        <i class="fas fa-copy"></i> Copy
                                                    </button>
                                                </div>
                                                
                                                <form method="post" class="mt-2">
                                                    <input type="hidden" name="user_id" value="<?php echo $uid; ?>">
                                                    <input type="hidden" name="image_type" value="profile">
                                                    <button type="submit" name="delete_image" class="btn btn-danger btn-sm">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>
                                                </form>
                                            <?php else: ?>
                                                <div class="bg-light p-5 text-center mb-3">
                                                    <i class="fas fa-user-circle fa-5x text-secondary"></i>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <form method="post" enctype="multipart/form-data" class="mt-3">
                                                <input type="hidden" name="user_id" value="<?php echo $uid; ?>">
                                                <div class="input-group">
                                                    <input type="file" class="form-control" name="profile_picture" accept="image/*" required>
                                                    <button class="btn btn-primary" type="submit">
                                                        <i class="fas fa-upload"></i> Upload
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <!-- NID Front Section -->
                                <div class="col-md-4 text-center">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5>NID Front</h5>
                                        </div>
                                        <div class="card-body">
                                            <?php if (!empty($userData['nid_front'])): 
                                                $nidFrontUrl = getFullUrl($userData['nid_front']);
                                            ?>
                                                <div class="image-container">
                                                    <img src="<?php echo htmlspecialchars($nidFrontUrl); ?>" 
                                                         class="img-thumbnail mb-2"
                                                         onclick="window.open('<?php echo htmlspecialchars($nidFrontUrl); ?>', '_blank')"
                                                         alt="NID Front"
                                                         title="Click to view in new tab">
                                                </div>
                                                
                                                <div class="d-flex align-items-center">
                                                    <a href="<?php echo htmlspecialchars($nidFrontUrl); ?>" 
                                                       target="_blank" 
                                                       class="file-link">
                                                       <?php echo htmlspecialchars($nidFrontUrl); ?>
                                                    </a>
                                                    <button class="copy-btn" onclick="copyToClipboard('<?php echo htmlspecialchars($nidFrontUrl); ?>')">
                                                        <i class="fas fa-copy"></i> Copy
                                                    </button>
                                                </div>
                                                
                                                <form method="post" class="mt-2">
                                                    <input type="hidden" name="user_id" value="<?php echo $uid; ?>">
                                                    <input type="hidden" name="image_type" value="nid_front">
                                                    <button type="submit" name="delete_image" class="btn btn-danger btn-sm">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>
                                                </form>
                                            <?php else: ?>
                                                <div class="bg-light p-5 text-center mb-3">
                                                    <i class="fas fa-id-card fa-5x text-secondary"></i>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <form method="post" enctype="multipart/form-data" class="mt-3">
                                                <input type="hidden" name="user_id" value="<?php echo $uid; ?>">
                                                <div class="input-group">
                                                    <input type="file" class="form-control" name="nid_front" accept="image/*" required>
                                                    <button class="btn btn-primary" type="submit">
                                                        <i class="fas fa-upload"></i> Upload
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <!-- NID Back Section -->
                                <div class="col-md-4 text-center">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5>NID Back</h5>
                                        </div>
                                        <div class="card-body">
                                            <?php if (!empty($userData['nid_back'])): 
                                                $nidBackUrl = getFullUrl($userData['nid_back']);
                                            ?>
                                                <div class="image-container">
                                                    <img src="<?php echo htmlspecialchars($nidBackUrl); ?>" 
                                                         class="img-thumbnail mb-2"
                                                         onclick="window.open('<?php echo htmlspecialchars($nidBackUrl); ?>', '_blank')"
                                                         alt="NID Back"
                                                         title="Click to view in new tab">
                                                </div>
                                                
                                                <div class="d-flex align-items-center">
                                                    <a href="<?php echo htmlspecialchars($nidBackUrl); ?>" 
                                                       target="_blank" 
                                                       class="file-link">
                                                       <?php echo htmlspecialchars($nidBackUrl); ?>
                                                    </a>
                                                    <button class="copy-btn" onclick="copyToClipboard('<?php echo htmlspecialchars($nidBackUrl); ?>')">
                                                        <i class="fas fa-copy"></i> Copy
                                                    </button>
                                                </div>
                                                
                                                <form method="post" class="mt-2">
                                                    <input type="hidden" name="user_id" value="<?php echo $uid; ?>">
                                                    <input type="hidden" name="image_type" value="nid_back">
                                                    <button type="submit" name="delete_image" class="btn btn-danger btn-sm">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>
                                                </form>
                                            <?php else: ?>
                                                <div class="bg-light p-5 text-center mb-3">
                                                    <i class="fas fa-id-card fa-5x text-secondary"></i>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <form method="post" enctype="multipart/form-data" class="mt-3">
                                                <input type="hidden" name="user_id" value="<?php echo $uid; ?>">
                                                <div class="input-group">
                                                    <input type="file" class="form-control" name="nid_back" accept="image/*" required>
                                                    <button class="btn btn-primary" type="submit">
                                                        <i class="fas fa-upload"></i> Upload
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- User Information Form -->
                            <div class="card mb-4">
                                <div class="card-header bg-success text-white">
                                    <h4 class="mb-0">User Information</h4>
                                </div>
                                <div class="card-body">
                                    <form method="post">
                                        <input type="hidden" name="user_id" value="<?php echo $uid; ?>">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="username" class="form-label">Full Name</label>
                                                    <input type="text" class="form-control" id="username" name="username" 
                                                           value="<?php echo htmlspecialchars($userData['username']); ?>" required>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <label for="mobile_number" class="form-label">Phone Number</label>
                                                    <input type="text" class="form-control" id="mobile_number" name="mobile_number" 
                                                           value="<?php echo htmlspecialchars($userData['mobile_number']); ?>" required>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="password" class="form-label">Password</label>
                                                    <input type="text" class="form-control" id="password" name="password" 
                                                           value="<?php echo htmlspecialchars($userData['password']); ?>" required>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <label for="Balancer" class="form-label">Balance</label>
                                                    <input type="text" class="form-control" id="Balancer" name="Balancer" 
                                                           value="<?php echo htmlspecialchars($userData['Balancer']); ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3 form-check">
                                            <input type="checkbox" class="form-check-input" id="is_verified" name="is_verified" 
                                                  <?php echo ($userData['is_verified']) ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="is_verified">Verified Account</label>
                                        </div>
                                        
                                        <div class="d-grid gap-2">
                                            <button type="submit" name="update_info" class="btn btn-primary btn-lg">
                                                <i class="fas fa-save"></i> Update Information
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- Account Information -->
                            <div class="card">
                                <div class="card-header bg-secondary text-white">
                                    <h4 class="mb-0">Account Details</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <tr>
                                                <th width="30%">Account Created</th>
                                                <td><?php echo date('F j, Y, g:i a', strtotime($userData['created_at'])); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Last Login</th>
                                                <td><?php echo !empty($userData['last_login']) ? date('F j, Y, g:i a', strtotime($userData['last_login'])) : 'Never logged in'; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Account Status</th>
                                                <td>
                                                    <?php if ($userData['is_verified']): ?>
                                                        <span class="badge bg-success">Verified</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-warning">Unverified</span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>User ID</th>
                                                <td><?php echo $uid; ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Loans Tab -->
                <div class="tab-pane fade" id="loans" role="tabpanel">
                    <div class="card mb-4">
                        <div class="card-header bg-info text-white">
                            <h4 class="mb-0">Loan History</h4>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($loanHistory)): ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered loan-table">
                                        <thead>
                                            <tr>
                                                <th>Loan ID</th>
                                                <th>Loan Name</th>
                                                <th>Amount</th>
                                                <th>Duration</th>
                                                <th>Status</th>
                                                <th>Application Date</th>
                                                <th>Approved Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($loanHistory as $loan): 
                                                $statusClass = '';
                                                switch ($loan['status']) {
                                                    case 'approved':
                                                        $statusClass = 'bg-success';
                                                        break;
                                                    case 'pending':
                                                        $statusClass = 'bg-warning';
                                                        break;
                                                    case 'rejected':
                                                        $statusClass = 'bg-danger';
                                                        break;
                                                    case 'completed':
                                                        $statusClass = 'bg-info';
                                                        break;
                                                    default:
                                                        $statusClass = 'bg-secondary';
                                                }
                                            ?>
                                                <tr>
                                                    <td><?php echo $loan['id']; ?></td>
                                                    <td><?php echo htmlspecialchars($loan['loan_name']); ?></td>
                                                    <td>৳<?php echo number_format($loan['amount'], 2); ?></td>
                                                    <td><?php echo $loan['duration']; ?> months</td>
                                                    <td>
                                                        <span class="badge loan-status-badge <?php echo $statusClass; ?>">
                                                            <?php echo ucfirst($loan['status']); ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo date('M j, Y, g:i a', strtotime($loan['application_date'])); ?></td>
                                                    <td>
                                                        <?php 
                                                        if (!empty($loan['approved_date'])) {
                                                            echo date('M j, Y, g:i a', strtotime($loan['approved_date']));
                                                        } else {
                                                            echo '-';
                                                        }
                                                        ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="fas fa-file-invoice-dollar fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">No loan history found for this user.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Payments Tab -->
                <div class="tab-pane fade" id="payments" role="tabpanel">
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h4 class="mb-0">Loan Payments</h4>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($loanPayments)): ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Payment ID</th>
                                                <th>Loan ID</th>
                                                <th>Amount</th>
                                                <th>Payment Date</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($loanPayments as $payment): 
                                                $statusClass = $payment['status'] === 'completed' ? 'bg-success' : ($payment['status'] === 'pending' ? 'bg-warning' : 'bg-danger');
                                            ?>
                                                <tr>
                                                    <td><?php echo $payment['id']; ?></td>
                                                    <td><?php echo $payment['loan_id']; ?></td>
                                                    <td>৳<?php echo number_format($payment['amount'], 2); ?></td>
                                                    <td><?php echo date('M j, Y, g:i a', strtotime($payment['payment_date'])); ?></td>
                                                    <td>
                                                        <span class="badge <?php echo $statusClass; ?>">
                                                            <?php echo ucfirst($payment['status']); ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="fas fa-receipt fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">No loan payments found for this user.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Deposits Tab -->
                <div class="tab-pane fade" id="deposits" role="tabpanel">
                    <div class="card mb-4">
                        <div class="card-header bg-primary text-white">
                            <h4 class="mb-0">Deposit History</h4>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($deposits)): ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Deposit ID</th>
                                                <th>Method</th>
                                                <th>Amount</th>
                                                <th>Transaction ID</th>
                                                <th>Date</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($deposits as $deposit): 
                                                $statusClass = $deposit['status'] === 'approved' ? 'bg-success' : ($deposit['status'] === 'pending' ? 'bg-warning' : 'bg-danger');
                                            ?>
                                                <tr>
                                                    <td><?php echo $deposit['id']; ?></td>
                                                    <td><?php echo htmlspecialchars($deposit['method']); ?></td>
                                                    <td>৳<?php echo number_format($deposit['amount'], 2); ?></td>
                                                    <td><?php echo htmlspecialchars($deposit['trx_id']); ?></td>
                                                    <td><?php echo date('M j, Y, g:i a', strtotime($deposit['created_at'])); ?></td>
                                                    <td>
                                                        <span class="badge <?php echo $statusClass; ?>">
                                                            <?php echo ucfirst($deposit['status']); ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="fas fa-money-bill-wave fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">No deposit history found for this user.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Withdrawals Tab -->
                <div class="tab-pane fade" id="withdrawals" role="tabpanel">
                    <div class="card mb-4">
                        <div class="card-header bg-warning text-dark">
                            <h4 class="mb-0">Withdrawal History</h4>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($withdrawals)): ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Withdrawal ID</th>
                                                <th>Method</th>
                                                <th>Amount</th>
                                                <th>Bank Name</th>
                                                <th>Date</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($withdrawals as $withdrawal): 
                                                $statusClass = $withdrawal['status'] === 'approved' ? 'bg-success' : ($withdrawal['status'] === 'pending' ? 'bg-warning' : 'bg-danger');
                                            ?>
                                                <tr>
                                                    <td><?php echo $withdrawal['id']; ?></td>
                                                    <td><?php echo htmlspecialchars($withdrawal['methord']); ?></td>
                                                    <td>৳<?php echo number_format($withdrawal['amount'], 2); ?></td>
                                                    <td><?php echo htmlspecialchars($withdrawal['bank_name']); ?></td>
                                                    <td><?php echo date('M j, Y, g:i a', strtotime($withdrawal['time'])); ?></td>
                                                    <td>
                                                        <span class="badge <?php echo $statusClass; ?>">
                                                            <?php echo ucfirst($withdrawal['status']); ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="fas fa-hand-holding-usd fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">No withdrawal history found for this user.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include('../admin/includes/footer.php'); ?>

<!-- JavaScript Libraries -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
<script>
// Auto refresh page after image upload/delete
if (window.history.replaceState) {
    window.history.replaceState(null, null, window.location.href);
}

// Confirm before deleting images
document.querySelectorAll('button[name="delete_image"]').forEach(button => {
    button.addEventListener('click', function(e) {
        if (!confirm('Are you sure you want to delete this image?')) {
            e.preventDefault();
        }
    });
});

// Copy to clipboard function
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('Link copied to clipboard:\n' + text);
    }, function(err) {
        console.error('Could not copy text: ', err);
        alert('Failed to copy link. Please try again.');
    });
}

// Initialize tabs
var triggerTabList = [].slice.call(document.querySelectorAll('#userTabs button'))
triggerTabList.forEach(function (triggerEl) {
    new bootstrap.Tab(triggerEl)
})
</script>
</body>
</html>