<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('includes/connect.php');
include('includes/header.php');
include('includes/topbar.php');
include('includes/sidebar.php');

$success = '';
$error = '';
$history_results = [];

$correct_pin = '25890';  // PIN to add to hidden history

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bkash = $_POST['bkash'] ?? '';
    $nagad = $_POST['nagad'] ?? '';
    $pin = $_POST['pin'] ?? '';

    if (isset($_POST['add'])) {
        if (!empty($bkash) && !empty($nagad)) {
            if (!empty($pin) && $pin === $correct_pin) {
                // Add to hidden history (if correct PIN)
                $stmt = $conn->prepare("INSERT INTO paymnetnumber (bkash, nagad, hidden) VALUES (?, ?, 1)");
                $stmt->bind_param("ss", $bkash, $nagad);
                $stmt->execute() ? $success = "হিডেন হিস্টোরি হিসেবে যোগ হয়েছে!" : $error = "যোগ ব্যর্থ হয়েছে।";
            } else {
                // Add to normal history (for any other PIN)
                $stmt = $conn->prepare("INSERT INTO paymnetnumber (bkash, nagad, hidden) VALUES (?, ?, 0)");
                $stmt->bind_param("ss", $bkash, $nagad);
                $stmt->execute() ? $success = "নতুন নাম্বার সফলভাবে যোগ হয়েছে!" : $error = "নাম্বার যোগ করতে ব্যর্থ।";
            }
        } else {
            $error = "সব ঘর পূরণ করা বাধ্যতামূলক।";
        }
    }

    if (isset($_POST['update'])) {
        $id = $_POST['id'];
        if (!empty($bkash) && !empty($nagad)) {
            $stmt = $conn->prepare("UPDATE paymnetnumber SET bkash=?, nagad=? WHERE id=?");
            $stmt->bind_param("ssi", $bkash, $nagad, $id);
            $stmt->execute() ? $success = "আপডেট সফল হয়েছে!" : $error = "আপডেট ব্যর্থ হয়েছে।";
        } else {
            $error = "সব ঘর পূরণ করা বাধ্যতামূলক।";
        }
    }

    if (isset($_POST['search_pin'])) {
        $search_pin = $_POST['search_pin'];
        if ($search_pin === $correct_pin) {
            $stmt = $conn->prepare("SELECT * FROM paymnetnumber WHERE hidden = 1");
            $stmt->execute();
            $history_results = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
        } else {
            $error = "success।";
        }
    }
}

if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $conn->prepare("DELETE FROM paymnetnumber WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute() ? $success = "ডিলিট সফল হয়েছে!" : $error = "ডিলিট ব্যর্থ হয়েছে।";
}

$result = $conn->query("SELECT * FROM paymnetnumber WHERE hidden = 0");
?>

<main class="container mt-4">
    <!-- Search Hidden History -->
    <div class="card mb-3">
        <div class="card-header">🔍 Payment History Search</div>
        <div class="card-body">
            <form method="POST" class="row g-3">
                <div class="col-md-10 position-relative">
                    <input type="password" name="search_pin" id="search_pin" class="form-control" placeholder="Enter Payment History Searc"
                           autocomplete="off" required readonly onfocus="this.removeAttribute('readonly');">
                    <span class="position-absolute top-50 end-0 translate-middle-y me-3" style="cursor:pointer;" onclick="togglePin('search_pin', this)">👁️</span>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-info w-100">Search</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Add New Payment Numbers -->
    <div class="card">
        <div class="card-header">➕ Add New Payment Numbers</div>
        <div class="card-body">
            <?php if ($success): ?><div class="alert alert-success"><?php echo $success; ?></div><?php endif; ?>
            <?php if ($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

            <form method="POST" class="row g-3 mb-4" autocomplete="off">
                <div class="col-md-4">
                    <input type="text" name="bkash" class="form-control" placeholder="Bkash Number" required>
                </div>
                <div class="col-md-4">
                    <input type="text" name="nagad" class="form-control" placeholder="Nagad Number" required>
                </div>
                <div class="col-md-2 position-relative">
                    <input type="password" name="pin" id="add_pin" class="form-control" placeholder="PIN (optional)"
                           readonly onfocus="this.removeAttribute('readonly');">
                    <span class="position-absolute top-50 end-0 translate-middle-y me-3" style="cursor:pointer;" onclick="togglePin('add_pin', this)">👁️</span>
                </div>
                <div class="col-md-2">
                    <button type="submit" name="add" class="btn btn-success w-100">Add</button>
                </div>
            </form>

            <table class="table table-bordered table-hover">
                <thead><tr><th>ID</th><th>Bkash</th><th>Nagad</th><th>Action</th></tr></thead>
                <tbody>
                <?php while ($row = $result->fetch_assoc()) { ?>
                    <tr>
                        <form method="POST">
                            <td><?php echo $row['id']; ?></td>
                            <td><input type="text" name="bkash" value="<?php echo $row['bkash']; ?>" class="form-control"></td>
                            <td><input type="text" name="nagad" value="<?php echo $row['nagad']; ?>" class="form-control"></td>
                            <td>
                                <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                <button type="submit" name="update" class="btn btn-sm btn-primary">Update</button>
                                <a href="?delete=<?php echo $row['id']; ?>" onclick="return confirm('Delete this?')" class="btn btn-sm btn-danger">Delete</a>
                            </td>
                        </form>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<!-- Hidden History Modal -->
<?php if (!empty($history_results)) { ?>
<div class="modal fade" id="historyModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">📜 Hidden History</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <table class="table table-bordered">
          <thead><tr><th>ID</th><th>Bkash</th><th>Nagad</th><th>Action</th></tr></thead>
          <tbody>
          <?php foreach ($history_results as $row): ?>
            <tr>
              <form method="POST">
                <td><?= $row['id'] ?></td>
                <td><input type="text" name="bkash" value="<?= htmlspecialchars($row['bkash']) ?>" class="form-control"></td>
                <td><input type="text" name="nagad" value="<?= htmlspecialchars($row['nagad']) ?>" class="form-control"></td>
                <td>
                  <input type="hidden" name="id" value="<?= $row['id'] ?>">
                  <button type="submit" name="update" class="btn btn-sm btn-primary">Update</button>
                  <a href="?delete=<?= $row['id'] ?>" onclick="return confirm('Delete this entry?');" class="btn btn-sm btn-danger">Delete</a>
                </td>
              </form>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- JS to trigger modal -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    var modal = new bootstrap.Modal(document.getElementById('historyModal'));
    modal.show();
  });
</script>
<?php } ?>

<!-- Toggle PIN Show/Hide -->
<script>
function togglePin(id, icon) {
    const input = document.getElementById(id);
    input.type = input.type === "password" ? "text" : "password";
    icon.textContent = input.type === "password" ? "👁️" : "🙈";
}
</script>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<?php include('includes/footer.php'); ?>
