<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location:./login.php");
    exit();
}

include('includes/connect.php');
include('includes/header.php');
echo '<title>Admin Dashboard - Logo & Announcement</title>';
include('includes/topbar.php');
include('includes/sidebar.php');

// 1. Logo Management Functions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upload_logo'])) {
    $logo = $_FILES['logo']['name'];
    $tmp = $_FILES['logo']['tmp_name'];
    $target = "../images/logo/" . $logo;

    if (move_uploaded_file($tmp, $target)) {
        $sql_update = "UPDATE settings SET logo='$target' LIMIT 1";
        mysqli_query($conn, $sql_update);

        $sql_history = "INSERT INTO logo_history (logo_path) VALUES ('$target')";
        mysqli_query($conn, $sql_history);

        echo "<script>
            $(document).ready(function() {
                $('#successModal').modal('show');
                setTimeout(function() {
                    window.location.href = 'logo.php';
                }, 2000);
            });
        </script>";
    } else {
        echo "<p style='color:red;'>Failed to upload logo.</p>";
    }
}

// Logo history
$sql_history = "SELECT * FROM logo_history ORDER BY updated_at DESC";
$result_history = mysqli_query($conn, $sql_history);

if (isset($_GET['delete_id'])) {
    $delete_id = (int)$_GET['delete_id'];
    $sql_delete = "DELETE FROM logo_history WHERE id = $delete_id";
    if (mysqli_query($conn, $sql_delete)) {
        echo "<p style='color:red;'>History record deleted successfully!</p>";
    } else {
        echo "<p style='color:red;'>Error deleting record!</p>";
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_history'])) {
    $update_id = (int)$_POST['history_id'];
    $new_logo = $_FILES['new_logo']['name'];
    $tmp = $_FILES['new_logo']['tmp_name'];
    $target = "../images/logo/" . $new_logo;

    if (move_uploaded_file($tmp, $target)) {
        $sql_update_history = "UPDATE logo_history SET logo_path='$target' WHERE id = $update_id";
        if (mysqli_query($conn, $sql_update_history)) {
            echo "<p style='color:green;'>Logo history updated successfully!</p>";
        } else {
            echo "<p style='color:red;'>Error updating logo history.</p>";
        }
    } else {
        echo "<p style='color:red;'>Failed to upload new logo.</p>";
    }
}

// 2. Announcement Management Functions
// Create announcements table if not exists
$createAnnouncementTable = "CREATE TABLE IF NOT EXISTS `announcements` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `message_logged_in` text DEFAULT NULL,
    `message_guest` text DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if (!$conn->query($createAnnouncementTable)) {
    die("Error creating announcements table: " . $conn->error);
}

// Insert default announcement if empty
$checkAnnouncements = $conn->query("SELECT COUNT(*) as count FROM `announcements`");
if ($checkAnnouncements && $checkAnnouncements->fetch_assoc()['count'] == 0) {
    $defaultLoggedIn = "Mr. {username} Welcome To easy.loan001.com , আমরাই একমাত্র কোনো ডকুমেন্টস ছাড়া লোন দিচ্ছি, লোনের পরিমান মিনিমাম ৫০০০ টাকা থেকে ৫০০০০ টাকা পর্যন্ত এবং পরিশোধের সময় ৩মাস,৬মাস,৯মাস, এবং ১২ মাস, ধন্যবাদ..! হেল্পলাইন Whatsapp +8801806931849";
    $defaultGuest = "Welcome To easy.loan001.com , আমরাই একমাত্র কোনো ডকুমেন্টস ছাড়া লোন দিচ্ছি, লোনের পরিমান মিনিমাম ৫০০০ টাকা থেকে ৫০০০০ টাকা পর্যন্ত এবং পরিশোধের সময় ৩মাস,৬মাস,৯মাস, এবং ১২ মাস, ধন্যবাদ..! হেল্পলাইন Whatsapp +880180693184934";
    
    $conn->query("INSERT INTO `announcements` (`message_logged_in`, `message_guest`) 
                 VALUES ('$defaultLoggedIn', '$defaultGuest')");
}

// Handle announcement update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_announcement'])) {
    $messageLoggedIn = mysqli_real_escape_string($conn, $_POST['message_logged_in']);
    $messageGuest = mysqli_real_escape_string($conn, $_POST['message_guest']);
    
    $updateSql = "UPDATE announcements SET 
                 message_logged_in = '$messageLoggedIn',
                 message_guest = '$messageGuest'
                 WHERE id = 1";
    
    if (mysqli_query($conn, $updateSql)) {
        $announcementSuccess = "Announcement updated successfully!";
    } else {
        $announcementError = "Error updating announcement: " . mysqli_error($conn);
    }
}

// Get current announcement
$announcementSql = "SELECT * FROM announcements LIMIT 1";
$announcementResult = mysqli_query($conn, $announcementSql);
$announcement = mysqli_fetch_assoc($announcementResult);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Logo & Announcement</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        .management-section {
            max-width: 1000px;
            margin: 30px auto;
            padding: 30px;
            background-color: #f8f9fa;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .section-title {
            text-align: center;
            margin-bottom: 25px;
            font-weight: bold;
            color: #2c3e50;
            padding-bottom: 10px;
            border-bottom: 2px solid #e0e0e0;
        }
        .form-group label {
            font-weight: 600;
            color: #34495e;
        }
        textarea.form-control {
            min-height: 100px;
            resize: vertical;
        }
        .btn-primary-custom {
            background-color: #3498db;
            border: none;
            padding: 10px 20px;
            font-weight: 600;
        }
        .btn-primary-custom:hover {
            background-color: #2980b9;
        }
        .preview-box {
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 15px;
            margin-top: 20px;
        }
        .preview-title {
            font-weight: 600;
            margin-bottom: 10px;
            color: #2c3e50;
        }
        .history-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .history-table th, .history-table td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: left;
        }
        .history-table th {
            background-color: #f8f9fa;
        }
        .history-table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .nav-tabs {
            margin-bottom: 20px;
            border-bottom: 2px solid #dee2e6;
        }
        .nav-tabs .nav-link {
            border: none;
            color: #495057;
            font-weight: 600;
        }
        .nav-tabs .nav-link.active {
            color: #3498db;
            border-bottom: 3px solid #3498db;
            background-color: transparent;
        }
        .tab-content {
            padding: 20px 0;
        }
        .announcement-preview {
            background: #ffffff;
            border-radius: 10px;
            padding: 1px 15px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
        }
        .announcement-icon-preview {
            font-size: 20px;
            color: #04460c;
            margin-right: 15px;
        }
        .announcement-text-preview {
            flex: 1;
            font-size: 14px;
            font-weight: 500;
            white-space: nowrap;
            overflow: hidden;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="management-section">
            <!-- Tab Navigation -->
            <ul class="nav nav-tabs" id="managementTabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="logo-tab" data-toggle="tab" href="#logo" role="tab">Logo Management</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="announcement-tab" data-toggle="tab" href="#announcement" role="tab">Announcement</a>
                </li>
            </ul>

            <!-- Tab Content -->
            <div class="tab-content" id="managementTabsContent">
                <!-- Logo Management Tab -->
                <div class="tab-pane fade show active" id="logo" role="tabpanel">
                    <h4 class="section-title"><i class="fas fa-image"></i> Logo Management</h4>
                    
                    <!-- Logo Upload Form -->
                    <form method="POST" enctype="multipart/form-data">
                        <div class="form-group">
                            <label for="logo">Upload New Logo</label>
                            <input type="file" class="form-control-file" name="logo" required>
                        </div>
                        <button type="submit" name="upload_logo" class="btn btn-primary-custom">Update Logo</button>
                    </form>

                    <!-- Logo History Table -->
                    <h5 class="mt-4">Logo History</h5>
                    <table class="history-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Logo Path</th>
                                <th>Updated At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($row = mysqli_fetch_assoc($result_history)) { ?>
                                <tr>
                                    <td><?php echo $row['id']; ?></td>
                                    <td><a href="<?php echo $row['logo_path']; ?>" target="_blank">View Logo</a></td>
                                    <td><?php echo $row['updated_at']; ?></td>
                                    <td>
                                        <a href="?delete_id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm">Delete</a>
                                        <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#updateModal<?php echo $row['id']; ?>">Update</button>

                                        <!-- Update Modal -->
                                        <div class="modal fade" id="updateModal<?php echo $row['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="updateModalLabel">Update Logo History</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <form method="POST" enctype="multipart/form-data">
                                                            <input type="hidden" name="history_id" value="<?php echo $row['id']; ?>">
                                                            <div class="form-group">
                                                                <label for="new_logo">New Logo</label>
                                                                <input type="file" class="form-control-file" name="new_logo" required>
                                                            </div>
                                                            <button type="submit" name="update_history" class="btn btn-primary">Update Logo</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>

                <!-- Announcement Management Tab -->
                <div class="tab-pane fade" id="announcement" role="tabpanel">
                    <h4 class="section-title"><i class="fas fa-bullhorn"></i> Announcement Management</h4>
                    
                    <?php if(isset($announcementSuccess)): ?>
                        <div class="alert alert-success"><?php echo $announcementSuccess; ?></div>
                    <?php endif; ?>
                    
                    <?php if(isset($announcementError)): ?>
                        <div class="alert alert-danger"><?php echo $announcementError; ?></div>
                    <?php endif; ?>
                    
                    <form method="POST">
                        <div class="form-group">
                            <label for="message_logged_in">Message for Logged-in Users</label>
                            <textarea class="form-control" id="message_logged_in" name="message_logged_in" required><?php echo htmlspecialchars($announcement['message_logged_in']); ?></textarea>
                            <small class="text-muted">Use {username} to display the user's name</small>
                        </div>
                        
                        <div class="form-group">
                            <label for="message_guest">Message for Guests</label>
                            <textarea class="form-control" id="message_guest" name="message_guest" required><?php echo htmlspecialchars($announcement['message_guest']); ?></textarea>
                        </div>
                        
                        <div class="preview-box">
                            <div class="preview-title">Preview:</div>
                            <div class="announcement-preview">
                                <div class="announcement-icon-preview">
                                    <i class="fas fa-bell"></i>
                                </div>
                                <div class="announcement-text-preview">
                                    <marquee behavior="scroll" direction="left"><?php echo htmlspecialchars($announcement['message_guest']); ?></marquee>
                                </div>
                            </div>
                        </div>
                        
                        <button type="submit" name="update_announcement" class="btn btn-primary-custom mt-3">Update Announcement</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Success Modal -->
    <div class="modal fade" id="successModal" tabindex="-1" role="dialog" aria-labelledby="successModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="successModalLabel">Success</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Your changes have been successfully updated!</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Required Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    
    <script>
        // Live preview for announcement
        $(document).ready(function() {
            $('#message_guest').on('input', function() {
                $('.announcement-text-preview marquee').text($(this).val());
            });
            
            $('#message_logged_in').on('input', function() {
                // For demo purposes, we'll just show the guest message preview
                // In a real scenario, you might want to toggle between them
            });
            
            // Tab functionality
            $('#managementTabs a').on('click', function (e) {
                e.preventDefault();
                $(this).tab('show');
            });
        });
    </script>
</body>
</html>