<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include('includes/connect.php');

// লগিন লজিক
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // ইনপুট ভ্যালিডেশন
    if (empty($email) || empty($password)) {
        $_SESSION['status'] = "ইমেইল এবং পাসওয়ার্ড প্রয়োজন";
        header("location: login.php");
        exit();
    }

    // ইমেইল ফরম্যাট চেক
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $_SESSION['status'] = "সঠিক ইমেইল ফরম্যাট দিন";
        header("location: login.php");
        exit();
    }

    $sql = "SELECT * FROM admin WHERE email = ?";
    $stmt = $conn->prepare($sql);
    
    if (!$stmt) {
        $_SESSION['status'] = "ডাটাবেস ত্রুটি। পরে আবার চেষ্টা করুন";
        header("location: login.php");
        exit();
    }

    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $admin = $result->fetch_assoc();

        if (password_verify($password, $admin['password'])) {
            if ($admin['status'] === 'active') {
                $_SESSION['adminName'] = $admin['name'];
                $_SESSION['admin_type'] = $admin['admin_type'];
                $_SESSION['adminLogin'] = true;
                
                // রিমেমবার মি কুকি সেট করা
                if (isset($_POST['remember'])) {
                    $cookie_value = base64_encode($admin['id'] . ':' . hash('sha256', $admin['password']));
                    setcookie('admin_remember', $cookie_value, time() + (86400 * 30), "/"); // ৩০ দিন
                }
                
                header("location: index.php");
                exit();
            } else {
                $_SESSION['status'] = "আপনার অ্যাকাউন্ট নিষ্ক্রিয়। সাপোর্টে যোগাযোগ করুন";
            }
        } else {
            $_SESSION['status'] = "ভুল ইমেইল বা পাসওয়ার্ড";
        }
    } else {
        $_SESSION['status'] = "ব্যবহারকারী খুঁজে পাওয়া যায়নি";
    }
    
    header("location: login.php");
    exit();
}

// লোগো ইতিহাস থেকে বর্তমান লোগো লোড করা
$current_logo = "";
$logo_query = "SELECT * FROM `logo_history` ORDER BY `updated_at` DESC LIMIT 1";
$logo_result = $conn->query($logo_query);
if ($logo_result && $logo_result->num_rows > 0) {
    $logo_data = $logo_result->fetch_assoc();
    $current_logo = $logo_data['logo_path'];
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>অ্যাডমিন লগিন | প্রিমিয়াম ড্যাশবোর্ড সিস্টেম</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #6e48aa 0%, #9d50bb 100%);
            --secondary-gradient: linear-gradient(135deg, #4776E6 0%, #8E54E9 100%);
            --glass-bg: rgba(255, 255, 255, 0.1);
            --glass-border: rgba(255, 255, 255, 0.2);
            --text-light: rgba(255, 255, 255, 0.95);
            --text-lighter: rgba(255, 255, 255, 0.7);
            --shadow-deep: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
            --shadow-light: 0 4px 6px -1px rgba(0, 0, 0, 0.2);
            --success-color: #2ecc71;
            --error-color: #e74c3c;
        }
        
        body {
            background: var(--primary-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
            font-family: 'Hind Siliguri', 'Poppins', sans-serif;
            overflow-x: hidden;
            color: var(--text-light);
        }
        
        #particles-js {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: -1;
            opacity: 0.7;
        }
        
        .login-container {
            width: 100%;
            max-width: 480px;
            padding: 20px;
            position: relative;
        }
        
        .login-card {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border-radius: 24px;
            border: 1px solid var(--glass-border);
            box-shadow: var(--shadow-deep);
            padding: 40px;
            color: var(--text-light);
            position: relative;
            overflow: hidden;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            z-index: 1;
        }
        
        .login-card::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(255, 255, 255, 0.1) 0%,
                rgba(255, 255, 255, 0) 60%
            );
            transform: rotate(30deg);
            z-index: -1;
        }
        
        .login-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.6);
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 40px;
            position: relative;
        }
        
        .login-logo {
            width: 100px;
            height: 100px;
            background: var(--secondary-gradient);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            border: 2px solid rgba(255, 255, 255, 0.3);
            transition: all 0.3s ease;
        }
        
        .login-logo:hover {
            transform: rotate(5deg) scale(1.05);
        }
        
        .login-logo img {
            max-width: 80%;
            max-height: 80%;
            object-fit: contain;
            transition: all 0.3s ease;
        }
        
        .login-title {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 8px;
            background: linear-gradient(to right, #fff, #e0e0e0);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            letter-spacing: 1px;
        }
        
        .login-subtitle {
            font-size: 14px;
            color: var(--text-lighter);
            margin-bottom: 0;
            letter-spacing: 0.5px;
        }
        
        .form-group {
            margin-bottom: 24px;
            position: relative;
        }
        
        .form-control {
            background-color: rgba(255, 255, 255, 0.15);
            color: var(--text-light);
            border: none;
            padding: 16px 20px 16px 45px;
            border-radius: 12px;
            transition: all 0.3s ease;
            height: auto;
            font-size: 15px;
            box-shadow: none;
            border: 1px solid transparent;
        }
        
        .form-control:focus {
            background-color: rgba(255, 255, 255, 0.25);
            color: var(--text-light);
            box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.3);
        }
        
        .form-control::placeholder {
            color: var(--text-lighter);
            opacity: 0.8;
        }
        
        .input-icon {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-lighter);
            font-size: 18px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus + .input-icon {
            color: var(--text-light);
            transform: translateY(-50%) scale(1.1);
        }
        
        .password-toggle {
            position: absolute;
            right: 18px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: var(--text-lighter);
            font-size: 18px;
            transition: all 0.3s ease;
            background: none;
            border: none;
            outline: none;
            padding: 5px;
        }
        
        .password-toggle:hover {
            color: var(--text-light);
            transform: translateY(-50%) scale(1.1);
        }
        
        .btn-login {
            background: var(--secondary-gradient);
            border: none;
            padding: 16px;
            font-weight: 600;
            border-radius: 12px;
            width: 100%;
            margin-top: 10px;
            transition: all 0.4s ease;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow: hidden;
            letter-spacing: 0.5px;
            font-size: 16px;
            text-transform: uppercase;
        }
        
        .btn-login:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
            letter-spacing: 1px;
        }
        
        .btn-login:active {
            transform: translateY(1px);
        }
        
        .btn-login::after {
            content: "";
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(255, 255, 255, 0.2) 0%,
                rgba(255, 255, 255, 0) 60%
            );
            transform: rotate(30deg);
            transition: all 0.5s ease;
        }
        
        .btn-login:hover::after {
            left: 100%;
        }
        
        .form-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 24px;
            font-size: 14px;
        }
        
        .form-check-label {
            color: var(--text-lighter);
            cursor: pointer;
            user-select: none;
            transition: all 0.3s ease;
        }
        
        .form-check-label:hover {
            color: var(--text-light);
        }
        
        .form-check-input {
            background-color: rgba(255, 255, 255, 0.15);
            border: none;
            margin-top: 0.1rem;
            width: 18px;
            height: 18px;
            transition: all 0.3s ease;
        }
        
        .form-check-input:checked {
            background-color: #8E54E9;
            border-color: #8E54E9;
        }
        
        .form-check-input:focus {
            box-shadow: 0 0 0 3px rgba(142, 84, 233, 0.25);
        }
        
        .forgot-password {
            color: var(--text-lighter);
            text-decoration: none;
            transition: all 0.3s ease;
            font-size: 14px;
        }
        
        .forgot-password:hover {
            color: white;
            text-decoration: underline;
        }
        
        .alert {
            background-color: rgba(231, 76, 60, 0.2);
            color: white;
            border: none;
            border-radius: 12px;
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            margin-bottom: 25px;
            padding: 12px 16px;
            border-left: 4px solid var(--error-color);
            animation: fadeIn 0.5s ease;
        }
        
        .alert i {
            margin-right: 8px;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .special-offer {
            background: linear-gradient(135deg, rgba(245, 215, 66, 0.9) 0%, rgba(243, 156, 18, 0.9) 100%);
            color: #333;
            border-radius: 12px;
            padding: 16px;
            margin-top: 30px;
            text-align: center;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2);
            animation: pulse 2s infinite;
            border: 1px solid rgba(255, 255, 255, 0.3);
            position: relative;
            overflow: hidden;
        }
        
        .special-offer::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(255, 255, 255, 0.2) 0%,
                rgba(255, 255, 255, 0) 60%
            );
            transform: rotate(30deg);
            z-index: 0;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2); }
            50% { transform: scale(1.02); box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3); }
            100% { transform: scale(1); box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2); }
        }
        
        .offer-title {
            font-weight: 700;
            margin-bottom: 8px;
            font-size: 16px;
            position: relative;
        }
        
        .offer-details {
            font-size: 14px;
            margin-bottom: 12px;
            position: relative;
        }
        
        .offer-price {
            font-weight: 700;
            color: #e74c3c;
            font-size: 18px;
            position: relative;
        }
        
        .whatsapp-btn {
            background-color: #25D366;
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 8px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 500;
            margin: 10px 0;
            box-shadow: 0 4px 10px rgba(37, 211, 102, 0.3);
            position: relative;
            overflow: hidden;
        }
        
        .whatsapp-btn:hover {
            background-color: #128C7E;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(37, 211, 102, 0.4);
        }
        
        .whatsapp-btn i {
            margin-right: 8px;
            font-size: 18px;
        }
        
        /* মডাল স্টাইল */
        .modal-content {
            background: rgba(0, 0, 0, 0.85);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            color: white;
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 16px;
            overflow: hidden;
        }
        
        .modal-header {
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 20px;
        }
        
        .modal-title {
            font-weight: 600;
        }
        
        .modal-body {
            padding: 25px;
        }
        
        .modal-footer {
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding: 20px;
        }
        
        .btn-close {
            filter: invert(1);
            opacity: 0.8;
            transition: all 0.3s ease;
        }
        
        .btn-close:hover {
            opacity: 1;
            transform: rotate(90deg);
        }
        
        .list-group-item {
            background-color: transparent;
            color: var(--text-light);
            border-color: rgba(255, 255, 255, 0.1);
            padding: 12px 0;
            display: flex;
            align-items: center;
        }
        
        @media (max-width: 576px) {
            .login-card {
                padding: 30px 20px;
                border-radius: 18px;
            }
            
            .login-title {
                font-size: 24px;
            }
            
            .login-logo {
                width: 80px;
                height: 80px;
            }
            
            .form-control {
                padding: 14px 20px 14px 40px;
            }
            
            .input-icon {
                left: 15px;
                font-size: 16px;
            }
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <div id="particles-js"></div>
    
    <div class="login-container animate__animated animate__fadeIn">
        <div class="login-card">
            <div class="login-header">
                <div class="login-logo">
                    <?php if(!empty($current_logo)): ?>
                        <img src="<?php echo htmlspecialchars($current_logo); ?>" alt="Logo" class="img-fluid">
                    <?php else: ?>
                        <i class="fas fa-lock" style="font-size: 36px; color: white;"></i>
                    <?php endif; ?>
                </div>
                <h1 class="login-title">অ্যাডমিন পোর্টাল</h1>
                <p class="login-subtitle">প্রিমিয়াম ড্যাশবোর্ড সিস্টেম</p>
            </div>
            
            <?php
            if (isset($_SESSION['status'])) {
                echo '<div class="alert alert-danger mb-4 animate__animated animate__fadeInDown">' . 
                     '<i class="fas fa-exclamation-circle"></i>' . 
                     htmlspecialchars($_SESSION['status']) . '</div>';
                unset($_SESSION['status']);
            }
            ?>
            
            <form method="post" autocomplete="off">
                <div class="form-group">
                    <i class="fas fa-envelope input-icon"></i>
                    <input type="email" class="form-control" name="email" placeholder="ইমেইল ঠিকানা" required autocomplete="off">
                </div>
                
                <div class="form-group">
                    <i class="fas fa-lock input-icon"></i>
                    <input type="password" class="form-control" id="password" name="password" placeholder="পাসওয়ার্ড" required autocomplete="off">
                    <button type="button" class="password-toggle" id="togglePassword">
                        <i class="fas fa-eye"></i>
                    </button>
                </div>
                
                <div class="form-footer">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="remember" name="remember">
                        <label class="form-check-label" for="remember">আমাকে মনে রাখুন</label>
                    </div>
                    <a href="#" class="forgot-password" data-bs-toggle="modal" data-bs-target="#forgotPasswordModal">পাসওয়ার্ড ভুলে গেছেন?</a>
                </div>
                
                <button type="submit" class="btn btn-login">
                    <i class="fas fa-sign-in-alt me-2"></i> লগিন করুন
                </button>
            </form>
            
            <div class="special-offer">
                <div class="offer-title">🚀 সীমিত সময়ের অফার!</div>
                <p class="offer-details">
                    এই প্রিমিয়াম সিস্টেমটি এখনই সংগ্রহ করুন
                </p>
                <button class="btn btn-sm btn-dark mt-2" data-bs-toggle="modal" data-bs-target="#offerModal" style="position: relative;">
                    বিস্তারিত দেখুন
                </button>
            </div>
        </div>
    </div>

    <!-- পাসওয়ার্ড ভুলে গেছেন মডাল -->
    <div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-key me-2"></i> পাসওয়ার্ড রিকভারি</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>পাসওয়ার্ড রিসেট লিংক পেতে আপনার ইমেইল ঠিকানা লিখুন:</p>
                    <div class="form-group mb-4">
                        <i class="fas fa-envelope input-icon"></i>
                        <input type="email" class="form-control" placeholder="আপনার রেজিস্টার্ড ইমেইল" id="recoveryEmail">
                    </div>
                    <div class="alert alert-info" style="display: none;" id="recoveryMessage"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">বন্ধ করুন</button>
                    <button type="button" class="btn btn-primary" id="sendRecoveryLink">রিসেট লিংক পাঠান</button>
                </div>
            </div>
        </div>
    </div>

    <!-- অফার ডিটেইলস মডাল -->
    <div class="modal fade" id="offerModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-gift me-2"></i> বিশেষ অফার বিস্তারিত</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <i class="fas fa-crown fa-3x text-warning mb-3" style="text-shadow: 0 2px 5px rgba(0,0,0,0.2);"></i>
                        <h4>প্রিমিয়াম অ্যাডমিন সিস্টেম</h4>
                    </div>
                    <ul class="list-group list-group-flush mb-4">
                        <li class="list-group-item"><i class="fas fa-check-circle text-success me-2"></i> সম্পূর্ণ অ্যাডমিন ড্যাশবোর্ড</li>
                        <li class="list-group-item"><i class="fas fa-check-circle text-success me-2"></i> ব্যবহারকারী ব্যবস্থাপনা সিস্টেম</li>
                        <li class="list-group-item"><i class="fas fa-check-circle text-success me-2"></i> উন্নত বিশ্লেষণ টুলস</li>
                        <li class="list-group-item"><i class="fas fa-check-circle text-success me-2"></i> প্রিমিয়াম সাপোর্ট</li>
                        <li class="list-group-item"><i class="fas fa-check-circle text-success me-2"></i> আজীবন আপডেট</li>
                    </ul>
                    <div class="text-center">
                        <h3 class="text-warning">৳২০,০০০</h3>
                        <small class="text-muted"><del>আসল মূল্য: ৳৫০,০০০</del></small>
                        <p class="mt-3 mb-4">এই এক্সক্লুসিভ অফার পেতে এখনই যোগাযোগ করুন!</p>
                        <a href="https://wa.me/8801XXXXXXXXX?text=আমি%20প্রিমিয়াম%20অ্যাডমিন%20সিস্টেম%20কিনতে%20চাই" class="whatsapp-btn mb-3" target="_blank">
                            <i class="fab fa-whatsapp"></i> WhatsApp এ বার্তা পাঠান
                        </a>
                        <p><i class="fas fa-phone me-2"></i> ০১XXXXXXXXX</p>
                        <p><i class="fas fa-envelope me-2"></i> sales@example.com</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">বন্ধ করুন</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // পাসওয়ার্ড টগল ভিজিবিলিটি
        const togglePassword = document.querySelector('#togglePassword');
        const password = document.querySelector('#password');
        
        togglePassword.addEventListener('click', function() {
            const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
            password.setAttribute('type', type);
            this.innerHTML = type === 'password' ? '<i class="fas fa-eye"></i>' : '<i class="fas fa-eye-slash"></i>';
        });
        
        // পার্টিকেল.js ইনিশিয়ালাইজেশন
        document.addEventListener('DOMContentLoaded', function() {
            particlesJS('particles-js', {
                "particles": {
                    "number": {
                        "value": 80,
                        "density": {
                            "enable": true,
                            "value_area": 800
                        }
                    },
                    "color": {
                        "value": "#ffffff"
                    },
                    "shape": {
                        "type": "circle",
                        "stroke": {
                            "width": 0,
                            "color": "#000000"
                        },
                        "polygon": {
                            "nb_sides": 5
                        }
                    },
                    "opacity": {
                        "value": 0.5,
                        "random": true,
                        "anim": {
                            "enable": true,
                            "speed": 1,
                            "opacity_min": 0.1,
                            "sync": false
                        }
                    },
                    "size": {
                        "value": 3,
                        "random": true,
                        "anim": {
                            "enable": true,
                            "speed": 2,
                            "size_min": 0.1,
                            "sync": false
                        }
                    },
                    "line_linked": {
                        "enable": true,
                        "distance": 150,
                        "color": "#ffffff",
                        "opacity": 0.2,
                        "width": 1
                    },
                    "move": {
                        "enable": true,
                        "speed": 2,
                        "direction": "none",
                        "random": true,
                        "straight": false,
                        "out_mode": "out",
                        "bounce": false,
                        "attract": {
                            "enable": true,
                            "rotateX": 600,
                            "rotateY": 1200
                        }
                    }
                },
                "interactivity": {
                    "detect_on": "canvas",
                    "events": {
                        "onhover": {
                            "enable": true,
                            "mode": "repulse"
                        },
                        "onclick": {
                            "enable": true,
                            "mode": "push"
                        },
                        "resize": true
                    },
                    "modes": {
                        "grab": {
                            "distance": 400,
                            "line_linked": {
                                "opacity": 1
                            }
                        },
                        "bubble": {
                            "distance": 400,
                            "size": 40,
                            "duration": 2,
                            "opacity": 8,
                            "speed": 3
                        },
                        "repulse": {
                            "distance": 100,
                            "duration": 0.4
                        },
                        "push": {
                            "particles_nb": 4
                        },
                        "remove": {
                            "particles_nb": 2
                        }
                    }
                },
                "retina_detect": true
            });
            
            // লগিন কার্ডে হোভার ইফেক্ট
            const loginCard = document.querySelector('.login-card');
            loginCard.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-8px)';
            });
            
            loginCard.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
            
            // পাসওয়ার্ড রিকভারি ফর্ম
            const sendRecoveryLink = document.getElementById('sendRecoveryLink');
            const recoveryEmail = document.getElementById('recoveryEmail');
            const recoveryMessage = document.getElementById('recoveryMessage');
            
            sendRecoveryLink.addEventListener('click', function() {
                if (recoveryEmail.value === '') {
                    recoveryMessage.style.display = 'block';
                    recoveryMessage.innerHTML = '<i class="fas fa-exclamation-circle me-2"></i>ইমেইল ঠিকানা লিখুন';
                    recoveryMessage.className = 'alert alert-danger';
                } else if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(recoveryEmail.value)) {
                    recoveryMessage.style.display = 'block';
                    recoveryMessage.innerHTML = '<i class="fas fa-exclamation-circle me-2"></i>সঠিক ইমেইল ফরম্যাট দিন';
                    recoveryMessage.className = 'alert alert-danger';
                } else {
                    // এখানে AJAX রিকুয়েস্ট পাঠানো যাবে
                    recoveryMessage.style.display = 'block';
                    recoveryMessage.innerHTML = '<i class="fas fa-check-circle me-2"></i>রিসেট লিংক আপনার ইমেইলে পাঠানো হয়েছে';
                    recoveryMessage.className = 'alert alert-success';
                    
                    // 3 সেকেন্ড পর মেসেজ হাইড করা
                    setTimeout(() => {
                        recoveryMessage.style.display = 'none';
                    }, 3000);
                }
            });
        });
    </script>
</body>
</html>