<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location: ./login.php");
    exit();
}

include('includes/connect.php');
$conn->set_charset("utf8mb4");

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate and sanitize input
    $loanAmount = filter_input(INPUT_POST, 'loanAmount', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
    $loanId = filter_input(INPUT_POST, 'loanId', FILTER_SANITIZE_NUMBER_INT);
    $loanTime = filter_input(INPUT_POST, 'loanTime', FILTER_SANITIZE_NUMBER_INT);
    $advance = filter_input(INPUT_POST, 'advance', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
    $profitPersatice = filter_input(INPUT_POST, 'profitPersatice', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
    $totalEmi = filter_input(INPUT_POST, 'totalEmi', FILTER_SANITIZE_NUMBER_INT);
    $totalEmiAmount = filter_input(INPUT_POST, 'totalEmiAmount', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
    $TotalPayableAmount = filter_input(INPUT_POST, 'TotalPayableAmount', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

    // Validate all required fields
    if ($loanAmount === false || $loanId === false || $loanTime === false || $advance === false || 
        $profitPersatice === false || $totalEmi === false || $totalEmiAmount === false || $TotalPayableAmount === false) {
        $_SESSION['status'] = "Error: Invalid input data";
        header("Location: loanAdd.php");
        exit();
    }

    $stmt = $conn->prepare("INSERT INTO productloan (
        loanAmount, loanId, loanTime, advance, profitPersatice, totalEmi, totalEmiAmount, TotalPayableAmount
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");

    // Changed "didiiddd" to "diiidddd" to match the parameter types
    $stmt->bind_param("diiidddd", $loanAmount, $loanId, $loanTime, $advance, $profitPersatice, $totalEmi, $totalEmiAmount, $TotalPayableAmount);

    if ($stmt->execute()) {
        $_SESSION['status'] = "Loan data saved successfully!";
    } else {
        $_SESSION['status'] = "Error: " . $stmt->error;
    }
    $stmt->close();
    header("Location: loanAdd.php");
    exit();
}

include('includes/header.php');
echo '<title>Loan Add</title>';
include('includes/topbar.php');
include('includes/sidebar.php');
?>

<main>
    <div class="container-fluid px-4">
        <h1 class="mt-4">Dashboard</h1>

        <?php if (isset($_SESSION['status'])): ?>
            <div class="alert alert-info shadow-sm rounded">
                <?= htmlspecialchars($_SESSION['status']); unset($_SESSION['status']); ?>
            </div>
        <?php endif; ?>

        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Loan Add</li>
        </ol>

        <div class="container mt-4 mb-5">
            <div class="card shadow rounded border-0 bg-white">
                <div class="card-header bg-primary text-white fs-5">
                    Add Product Loan
                </div>
                <div class="card-body p-4">
                    <form action="loanAdd.php" method="post" onsubmit="return validateForm()">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="loanAmount" class="form-label">Loan Amount</label>
                                <input type="number" step="0.01" class="form-control" id="loanAmount" name="loanAmount" required>
                            </div>
                            <div class="col-md-6">
                                <label for="loanId" class="form-label">Loan Type</label>
                                <select class="form-select" id="loanId" name="loanId" required>
                                    <option value="">Select Loan Type</option>
                                    <?php
                                    $result = $conn->query("SELECT * FROM `loanname` ORDER BY `id` ASC");
                                    while ($row = $result->fetch_assoc()) {
                                        echo "<option value='".htmlspecialchars($row['id'])."'>".htmlspecialchars($row['id'])." - ".htmlspecialchars($row['loanName'])."</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="loanTime" class="form-label">Loan Time (Months)</label>
                                <input type="number" class="form-control" id="loanTime" name="loanTime" min="1" required>
                            </div>
                            <div class="col-md-4">
                                <label for="advance" class="form-label">Advance</label>
                                <input type="number" step="0.01" class="form-control" id="advance" name="advance" required>
                            </div>
                            <div class="col-md-4">
                                <label for="profitPersatice" class="form-label">Profit (%)</label>
                                <input type="number" step="0.01" class="form-control" id="profitPersatice" name="profitPersatice" required>
                            </div>
                            <div class="col-md-6">
                                <label for="totalEmi" class="form-label">Total EMI</label>
                                <input type="number" class="form-control" id="totalEmi" name="totalEmi" min="1" required>
                            </div>
                            <div class="col-md-6">
                                <label for="totalEmiAmount" class="form-label">Total EMI Amount</label>
                                <input type="number" step="0.01" class="form-control" id="totalEmiAmount" name="totalEmiAmount" required>
                            </div>
                            <div class="col-12">
                                <label for="TotalPayableAmount" class="form-label">Total Payable Amount</label>
                                <input type="number" step="0.01" class="form-control" id="TotalPayableAmount" name="TotalPayableAmount" required>
                            </div>
                            <div class="col-12 mt-3">
                                <button type="submit" class="btn btn-success w-100 shadow-sm">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <h2 class="mb-4">Product Loan Records</h2>

        <div class="table-responsive">
            <table class="table table-striped table-hover border rounded shadow-sm">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Loan Amount</th>
                        <th>Loan Name</th>
                        <th>Loan Time</th>
                        <th>Advance</th>
                        <th>Profit (%)</th>
                        <th>Total EMI</th>
                        <th>Total EMI Amount</th>
                        <th>Total Payable</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $sql = "SELECT p.*, l.loanName FROM productloan p JOIN loanname l ON p.loanId = l.id ORDER BY p.id DESC";
                $result = $conn->query($sql);
                if ($result->num_rows > 0): 
                    while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['id']) ?></td>
                            <td><?= number_format($row['loanAmount'], 2) ?></td>
                            <td><?= htmlspecialchars($row['loanName']) ?></td>
                            <td><?= htmlspecialchars($row['loanTime']) ?></td>
                            <td><?= number_format($row['advance'], 2) ?></td>
                            <td><?= number_format($row['profitPersatice'], 2) ?></td>
                            <td><?= htmlspecialchars($row['totalEmi']) ?></td>
                            <td><?= number_format($row['totalEmiAmount'], 2) ?></td>
                            <td><?= number_format($row['TotalPayableAmount'], 2) ?></td>
                            <td>
                                <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal" data-id="<?= htmlspecialchars($row['id']) ?>">
                                    Delete
                                </button>
                            </td>
                        </tr>
                    <?php endwhile;
                else: ?>
                    <tr><td colspan="10" class="text-center">No data found</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        Are you sure you want to delete this record?
      </div>
      <div class="modal-footer">
        <form id="deleteForm" method="GET" action="delete_productloan.php">
            <input type="hidden" name="id" id="deleteId">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-danger">Delete</button>
        </form>
      </div>
    </div>
  </div>
</div>

<?php include('includes/footer.php'); ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    var deleteModal = document.getElementById('deleteModal');
    deleteModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var loanId = button.getAttribute('data-id');
        document.getElementById('deleteId').value = loanId;
    });
});

function validateForm() {
    const loanAmount = parseFloat(document.getElementById('loanAmount').value);
    const advance = parseFloat(document.getElementById('advance').value);
    
    if (advance >= loanAmount) {
        alert('Advance amount cannot be greater than or equal to loan amount');
        return false;
    }
    
    return true;
}
</script>