<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('includes/connect.php');
include('includes/header.php');
include('includes/topbar.php');
include('includes/sidebar.php');

// Check if ID is provided and valid
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: testimonial_system.php");
    exit();
}

$id = (int)$_GET['id'];
$error = '';
$success = '';

// Fetch testimonial data
$stmt = $conn->prepare("SELECT * FROM testimonials WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    header("Location: testimonial_system.php");
    exit();
}

$testimonial = $result->fetch_assoc();
$stmt->close();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $message = trim($_POST['message']);

    if (!empty($name) && !empty($message)) {
        $stmt = $conn->prepare("UPDATE testimonials SET name = ?, message = ? WHERE id = ?");
        $stmt->bind_param("ssi", $name, $message, $id);
        
        if ($stmt->execute()) {
            $success = "Testimonial updated successfully!";
            // Refresh the data
            $testimonial['name'] = $name;
            $testimonial['message'] = $message;
            echo "<script>setTimeout(function(){ window.location.href = 'testimonial_system.php'; }, 1500);</script>";
        } else {
            $error = "Failed to update testimonial: " . $conn->error;
        }
        $stmt->close();
    } else {
        $error = "Name and Message are required.";
    }
}
?>

<div class="container mt-5">
    <div class="card shadow p-4">
        <h4 class="mb-3">Edit Testimonial</h4>
        <a href="testimonial_system.php" class="btn btn-secondary mb-3">
            <i class="bi bi-arrow-left"></i> Back to Testimonials
        </a>
        
        <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?= $success ?></div>
        <?php elseif (!empty($error)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Customer Name</label>
                <input type="text" name="name" class="form-control" 
                       value="<?= htmlspecialchars($testimonial['name'] ?? '') ?>" required />
            </div>
            <div class="mb-3">
                <label class="form-label">Review Message</label>
                <textarea name="message" class="form-control" rows="4" required><?= 
                    htmlspecialchars($testimonial['message'] ?? '') ?></textarea>
            </div>
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Update Testimonial
            </button>
        </form>
    </div>
</div>

<?php include('includes/footer.php'); ?>