<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location: ./login.php");
    exit();
}

include('includes/connect.php');
$conn->set_charset("utf8mb4");

// Load PIN and hidden number from DB
$pinRow = $conn->query("SELECT setting_value FROM admin_settings WHERE setting_key = 'pin'")->fetch_assoc();
$hiddenRow = $conn->query("SELECT setting_value FROM admin_settings WHERE setting_key = 'hidden_number'")->fetch_assoc();
$storedPin = $pinRow['setting_value'];
$hiddenNumber = $hiddenRow['setting_value'];

$showHiddenDeposits = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reveal_hidden'])) {
    $enteredPin = $_POST['pin'];
    if ($enteredPin === $storedPin) {
        $showHiddenDeposits = true;
        $_SESSION['status'] = "🔓 deposits unlocked!";
    } else {
        $_SESSION['status'] = "❌ Incorrect PIN!";
    }
}

// Approve
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] === "approve") {
    $depositId = $_POST['deposit_id'];
    $userId = $_POST['userID'];
    $amount = $_POST['amount'];

    $check = $conn->query("SELECT status FROM deposits WHERE id = '$depositId'");
    $row = $check->fetch_assoc();
    if ($row && $row['status'] === 'success') {
        $_SESSION['status'] = "⛔ This deposit has already been approved.";
        header("Location: depositerequst.php");
        exit();
    }

    $updateDepositSql = "UPDATE deposits SET status = 'success' WHERE id = '$depositId'";
    $updateUserBalanceSql = "UPDATE user SET Balancer = Balancer + $amount WHERE id = '$userId'";

    $conn->begin_transaction();
    try {
        if ($conn->query($updateDepositSql)) {
            if ($conn->query($updateUserBalanceSql)) {
                $conn->commit();
                $_SESSION['status'] = "✅ Deposit approved and user balance updated.";
            } else {
                throw new Exception("❌ Error updating user balance");
            }
        } else {
            throw new Exception("❌ Error updating deposit status");
        }
    } catch (Exception $e) {
        $conn->rollback();
        $_SESSION['status'] = "❗ Transaction failed: " . $e->getMessage();
    }
    header("Location: depositerequst.php");
    exit();
}

// Delete
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] === "delete") {
    $depositId = $_POST['deposit_id'];
    $sql = "DELETE FROM deposits WHERE id = ?";
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("i", $depositId);
        if ($stmt->execute()) {
            $_SESSION['status'] = "🗑️ Deposit deleted. ID: " . $depositId;
        } else {
            $_SESSION['status'] = "Error: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $_SESSION['status'] = "Error preparing query.";
    }
    header("Location: depositerequst.php");
    exit();
}

include('includes/header.php');
echo '<title>Deposit Request</title>';
include('includes/topbar.php');
include('includes/sidebar.php');
?>

<main class="bg-light min-vh-100">
    <div class="container py-5">
        <form method="POST" class="mb-4">
            <div class="input-group w-50 mx-auto">
                <input type="password" name="pin" class="form-control text-center fw-bold" placeholder="🔒 Enter to view deposits List" required>
                <button type="submit" name="reveal_hidden" class="btn btn-dark">Search</button>
            </div>
        </form>

        <?php if (isset($_SESSION['status'])): ?>
            <div class="alert alert-info shadow rounded fw-bold text-center">
                <?= $_SESSION['status']; unset($_SESSION['status']); ?>
            </div>
        <?php endif; ?>

        <div class="card shadow-lg border-0">
            <div class="card-header bg-gradient-primary text-white py-3 rounded-top">
                <h4 class="mb-0 fw-bold">💳 Deposit Requests</h4>
            </div>
            <div class="card-body bg-white rounded-bottom">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover table-striped text-center align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th>Method</th>
                                <th>To Number</th>
                                <th>From Number</th>
                                <th>Amount</th>
                                <th>Trx ID</th>
                                <th>Front ID</th>
                                <th>Created At</th>
                                <th>Status</th>
                                <th>Username</th>
                                <th>Mobile</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $sql = "SELECT d.id AS deposit_id, d.userid, d.method, d.to_number, d.from_number, d.amount, d.trx_id,
                                    d.front_id_url, d.created_at, d.status, u.id AS user_id, u.username, u.mobile_number
                                    FROM deposits d JOIN user u ON d.userid = u.id
                                    WHERE d.status = 'pending'";

                            if ($showHiddenDeposits) {
                                $sql .= " AND d.from_number = '$hiddenNumber'";
                            } else {
                                $sql .= " AND d.from_number != '$hiddenNumber'";
                            }

                            $sql .= " ORDER BY d.userid ASC";

                            $result = $conn->query($sql);
                            if ($result->num_rows > 0):
                                while ($row = $result->fetch_assoc()):
                                    $depositId = $row['deposit_id'];
                                    $userId = $row['user_id'];
                            ?>
                            <tr>
                                <td><?= $row['method']; ?></td>
                                <td><?= $row['to_number']; ?></td>
                                <td><?= $row['from_number']; ?></td>
                                <td><span class="badge bg-success fw-bold"><?= $row['amount']; ?></span></td>
                                <td><?= $row['trx_id']; ?></td>
                                <td><img src="/<?= $row['front_id_url']; ?>" width="100" height="100" class="rounded shadow-sm"></td>
                                <td><?= $row['created_at']; ?></td>
                                <td><span class="badge bg-warning text-dark"><?= $row['status']; ?></span></td>
                                <td><?= $row['username']; ?></td>
                                <td><?= $row['mobile_number']; ?></td>
                                <td>
                                    <button class="btn btn-sm btn-success mb-1 shadow-sm" onclick="showApproveModal(<?= $depositId ?>, <?= $userId ?>, <?= $row['amount'] ?>)">✔️</button>
                                    <button class="btn btn-sm btn-danger shadow-sm" onclick="showDeleteModal(<?= $depositId ?>)">🗑️</button>
                                </td>
                            </tr>
                            <?php endwhile; endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- Approve Modal -->
<div class="modal fade" id="approveModal" tabindex="-1">
  <div class="modal-dialog">
    <form method="POST" class="modal-content">
      <input type="hidden" name="action" value="approve">
      <input type="hidden" name="deposit_id" id="approve_deposit_id">
      <input type="hidden" name="userID" id="approve_user_id">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Confirm Approval</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        Are you sure you want to approve this deposit? You can modify the amount if needed.
        <input type="number" class="form-control mt-3" name="amount" id="approve_amount" required>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-success">Approve</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
  <div class="modal-dialog">
    <form method="POST" class="modal-content">
      <input type="hidden" name="action" value="delete">
      <input type="hidden" name="deposit_id" id="delete_deposit_id">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title">Confirm Deletion</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        Are you sure you want to delete this deposit request?
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-danger">Yes, Delete</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<?php include('includes/footer.php'); ?>

<!-- CSS + JS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function showApproveModal(depositId, userId, amount) {
    const modal = new bootstrap.Modal(document.getElementById('approveModal'));
    document.getElementById('approve_deposit_id').value = depositId;
    document.getElementById('approve_user_id').value = userId;
    document.getElementById('approve_amount').value = amount;
    modal.show();
}
function showDeleteModal(depositId) {
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    document.getElementById('delete_deposit_id').value = depositId;
    modal.show();
}
</script>
<style>
body {
    background: linear-gradient(to right, #e0eafc, #cfdef3);
}
.bg-gradient-primary {
    background: linear-gradient(to right, #0062E6, #33AEFF);
}
.modal-content {
    border-radius: 1rem;
    box-shadow: 0 0 10px rgba(0,0,0,0.15);
}
table th, table td {
    vertical-align: middle !important;
}
img {
    object-fit: cover;
}
</style>
