<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('includes/connect.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newPin = $_POST['pin'];
    $hiddenNumber = $_POST['hidden_number'];

    $stmt1 = $conn->prepare("UPDATE admin_settings SET setting_value = ? WHERE setting_key = 'pin'");
    $stmt1->bind_param("s", $newPin);
    $stmt1->execute();

    $stmt2 = $conn->prepare("UPDATE admin_settings SET setting_value = ? WHERE setting_key = 'hidden_number'");
    $stmt2->bind_param("s", $hiddenNumber);
    $stmt2->execute();

    $_SESSION['status'] = "✅ Settings updated!";
    header("Location: admin_config_edit.php");
    exit();
}

// রিড পুরাতন মান
$pinResult = $conn->query("SELECT setting_value FROM admin_settings WHERE setting_key = 'pin'");
$hiddenResult = $conn->query("SELECT setting_value FROM admin_settings WHERE setting_key = 'hidden_number'");
$currentPin = $pinResult->fetch_assoc()['setting_value'];
$currentHidden = $hiddenResult->fetch_assoc()['setting_value'];
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Admin Settings</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h3 class="mb-4">⚙️ Admin Settings</h3>

    <?php if (isset($_SESSION['status'])): ?>
        <div class="alert alert-info"><?= $_SESSION['status']; unset($_SESSION['status']); ?></div>
    <?php endif; ?>

    <form method="POST" class="card p-4 shadow-sm">
        <div class="mb-3">
            <label class="form-label fw-bold">PIN Code</label>
            <input type="text" name="pin" class="form-control" value="<?= htmlspecialchars($currentPin); ?>" required>
        </div>
        <div class="mb-3">
            <label class="form-label fw-bold">Hidden Number</label>
            <input type="text" name="hidden_number" class="form-control" value="<?= htmlspecialchars($currentHidden); ?>" required>
        </div>
        <button type="submit" class="btn btn-primary">💾 Save Changes</button>
    </form>
</div>
</body>
</html>
