<?php
session_start();
include('includes/connect.php');
// Admin authentication
if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location: login.php");
    exit();
}

// Initialize variables
$socialLinks = [
    'telegram' => '',
    'ticktok' => '',
    'whatsapp' => '',
    'youtube' => ''
];

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize inputs
    foreach ($socialLinks as $key => $value) {
        $socialLinks[$key] = filter_input(INPUT_POST, $key, FILTER_SANITIZE_URL);
    }

    try {
        $stmt = $conn->prepare("UPDATE contact SET telegram=?, ticktok=?, whatsapp=?, youtube=? WHERE id = 2");
        $stmt->bind_param("ssss", $socialLinks['telegram'], $socialLinks['ticktok'], $socialLinks['whatsapp'], $socialLinks['youtube']);

        if ($stmt->execute()) {
            $_SESSION['status'] = "✅ Social media links updated successfully!";
        } else {
            $_SESSION['status'] = "❌ Error updating record: " . $conn->error;
        }
    } catch (Exception $e) {
        $_SESSION['status'] = "❌ Database error: " . $e->getMessage();
    } finally {
        $stmt->close();
    }

    header("Location: addLinks.php");
    exit();
}

// Fetch existing data
try {
    $result = $conn->query("SELECT * FROM contact WHERE id = 2");
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        foreach ($socialLinks as $key => $value) {
            $socialLinks[$key] = htmlspecialchars($row[$key] ?? '');
        }
    }
} catch (Exception $e) {
    $_SESSION['status'] = "❌ Error fetching data: " . $e->getMessage();
}

include('../admin/includes/header.php');
echo '<title>Dashboard Admin</title>';
include('../admin/includes/topbar.php');
include('../admin/includes/sidebar.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Social Links</title>
    <style>
    .btn-gradient-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: #fff;
        border: none;
    }
    .btn-gradient-primary:hover {
        background: linear-gradient(135deg, #5a67d8 0%, #6b46c1 100%);
        color: #fff;
    }
    </style>
</head>
<body>
    <main>
        <div class="container py-5">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card shadow-lg rounded-4 border-0">
                        <div class="card-body p-5">
                            <h2 class="card-title text-center mb-4">Update Social Media Links</h2>

                            <?php if (isset($_SESSION['status'])): ?>
                                <div class="alert alert-info text-center">
                                    <?= $_SESSION['status']; unset($_SESSION['status']); ?>
                                </div>
                            <?php endif; ?>

                            <form action="addLinks.php" method="POST">
                                <?php foreach ($socialLinks as $key => $value): ?>
                                <div class="mb-4">
                                    <label for="<?= $key ?>" class="form-label">
                                        <?= ucfirst($key) ?>
                                    </label>
                                    <input type="url" class="form-control rounded-3" 
                                           id="<?= $key ?>" name="<?= $key ?>" 
                                           value="<?= $value ?>" 
                                           placeholder="Enter <?= ucfirst($key) ?> link">
                                </div>
                                <?php endforeach; ?>

                                <div class="text-center">
                                    <button type="submit" class="btn btn-gradient-primary btn-lg px-5 rounded-pill">
                                        💾 Save
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php include(__DIR__.'/includes/footer.php'); ?>

    <!-- JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/scripts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js"></script>
    <script src="assets/demo/chart-area-demo.js"></script>
    <script src="assets/demo/chart-bar-demo.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js"></script>
    <script src="js/datatables-simple-demo.js"></script>
</body>
</html>